/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.scheduler;

import com.hazelcast.util.Clock;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

final class SecondsBasedEntryTaskScheduler<K, V>
implements EntryTaskScheduler<K, V> {
    private static final long initialTimeMillis = Clock.currentTimeMillis();
    private final ConcurrentMap<K, Integer> secondsOfKeys = new ConcurrentHashMap<K, Integer>(1000);
    private final ConcurrentMap<Integer, ConcurrentMap<K, ScheduledEntry<K, V>>> scheduledEntries = new ConcurrentHashMap<Integer, ConcurrentMap<K, ScheduledEntry<K, V>>>(1000);
    private final ScheduledExecutorService scheduledExecutorService;
    private final ScheduledEntryProcessor entryProcessor;
    private final boolean postponesSchedule;

    SecondsBasedEntryTaskScheduler(ScheduledExecutorService scheduledExecutorService, ScheduledEntryProcessor entryProcessor, boolean postponesSchedule) {
        this.scheduledExecutorService = scheduledExecutorService;
        this.entryProcessor = entryProcessor;
        this.postponesSchedule = postponesSchedule;
    }

    @Override
    public boolean schedule(long delayMillis, K key, V value) {
        if (this.postponesSchedule) {
            return this.scheduleEntry(delayMillis, key, value);
        }
        return this.scheduleIfNew(delayMillis, key, value);
    }

    @Override
    public Set<K> flush(Set<K> keys) {
        HashSet res = new HashSet(keys.size());
        HashSet<K> processedKeys = new HashSet<K>();
        for (K key : keys) {
            ConcurrentMap entries;
            Integer second = (Integer)this.secondsOfKeys.remove(key);
            if (second == null || (entries = (ConcurrentMap)this.scheduledEntries.get(second)) == null) continue;
            processedKeys.add(key);
            res.add(entries.remove(key));
        }
        this.entryProcessor.process(this, res);
        return processedKeys;
    }

    @Override
    public ScheduledEntry<K, V> cancel(K key) {
        ConcurrentMap entries;
        Integer second = (Integer)this.secondsOfKeys.remove(key);
        if (second != null && (entries = (ConcurrentMap)this.scheduledEntries.get(second)) != null) {
            return (ScheduledEntry)entries.remove(key);
        }
        return null;
    }

    private boolean scheduleEntry(long delayMillis, K key, V value) {
        int delaySeconds = this.ceilToSecond(delayMillis);
        Integer newSecond = this.findRelativeSecond(delayMillis);
        Integer existingSecond = this.secondsOfKeys.put(key, newSecond);
        if (existingSecond != null) {
            if (existingSecond.equals(newSecond)) {
                return false;
            }
            this.removeKeyFromSecond(key, existingSecond);
        }
        this.doSchedule(new ScheduledEntry<K, V>(key, value, delayMillis, delaySeconds), newSecond);
        return true;
    }

    private boolean scheduleIfNew(long delayMillis, K key, V value) {
        int delaySeconds = this.ceilToSecond(delayMillis);
        Integer newSecond = this.findRelativeSecond(delayMillis);
        if (this.secondsOfKeys.putIfAbsent(key, newSecond) != null) {
            return false;
        }
        this.doSchedule(new ScheduledEntry<K, V>(key, value, delayMillis, delaySeconds), newSecond);
        return true;
    }

    private int findRelativeSecond(long delayMillis) {
        long now = Clock.currentTimeMillis();
        long d = now + delayMillis - initialTimeMillis;
        return this.ceilToSecond(d);
    }

    private int ceilToSecond(long delayMillis) {
        return (int)Math.ceil((double)delayMillis / 1000.0);
    }

    private void doSchedule(ScheduledEntry<K, V> entry, Integer second) {
        ConcurrentMap<K, ScheduledEntry<K, ScheduledEntry<K, V>>> entries = (ConcurrentHashMap<K, ScheduledEntry<K, ScheduledEntry<K, V>>>)this.scheduledEntries.get(second);
        boolean shouldSchedule = false;
        if (entries == null) {
            entries = new ConcurrentHashMap<K, ScheduledEntry<K, ScheduledEntry<K, V>>>(10);
            ConcurrentMap existingScheduleKeys = this.scheduledEntries.putIfAbsent(second, entries);
            if (existingScheduleKeys != null) {
                entries = existingScheduleKeys;
            } else {
                shouldSchedule = true;
            }
        }
        entries.put(entry.getKey(), entry);
        if (shouldSchedule) {
            this.schedule(second, entry.getActualDelaySeconds());
        }
    }

    private void removeKeyFromSecond(K key, Integer existingSecond) {
        ConcurrentMap scheduledKeys = (ConcurrentMap)this.scheduledEntries.get(existingSecond);
        if (scheduledKeys != null) {
            scheduledKeys.remove(key);
        }
    }

    private void schedule(Integer second, int delaySeconds) {
        this.scheduledExecutorService.schedule(new EntryProcessorExecutor(second), (long)delaySeconds, TimeUnit.SECONDS);
    }

    @Override
    public int size() {
        return this.secondsOfKeys.size();
    }

    @Override
    public void cancelAll() {
        this.secondsOfKeys.clear();
        this.scheduledEntries.clear();
    }

    public String toString() {
        return "EntryTaskScheduler{secondsOfKeys=" + this.secondsOfKeys.size() + ", scheduledEntries [" + this.scheduledEntries.size() + "] =" + this.scheduledEntries.keySet() + '}';
    }

    private class EntryProcessorExecutor
    implements Runnable {
        private final Integer second;

        private EntryProcessorExecutor(Integer second) {
            this.second = second;
        }

        @Override
        public void run() {
            ConcurrentMap entries = (ConcurrentMap)SecondsBasedEntryTaskScheduler.this.scheduledEntries.remove(this.second);
            if (entries == null || entries.isEmpty()) {
                return;
            }
            HashSet values = new HashSet(entries.size());
            for (Object key : entries.keySet()) {
                Integer removed = (Integer)SecondsBasedEntryTaskScheduler.this.secondsOfKeys.remove(key);
                if (removed == null) continue;
                values.add(entries.get(key));
            }
            SecondsBasedEntryTaskScheduler.this.entryProcessor.process(SecondsBasedEntryTaskScheduler.this, values);
        }
    }
}

