/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.util.Hashtable;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.ldap.SRVRecord;
import org.wso2.carbon.utils.CarbonUtils;

public class LDAPConnectionContext {
    private Hashtable environment;
    private static Log log = LogFactory.getLog(LDAPConnectionContext.class);
    private SortedMap<Integer, SRVRecord> dcMap;
    private Hashtable environmentForDNS;
    private String DNSDomainName;
    private boolean readOnly = false;

    public LDAPConnectionContext(RealmConfiguration realmConfig) throws UserStoreException {
        String binaryAttribute;
        String DNSUrl = realmConfig.getUserStoreProperty("URLOfDNS");
        if (DNSUrl != null) {
            this.DNSDomainName = realmConfig.getUserStoreProperty("DNSDomainName");
            if (this.DNSDomainName == null) {
                throw new UserStoreException("DNS is enabled, but DNS domain name not provided.");
            }
            this.environmentForDNS = new Hashtable();
            this.environmentForDNS.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            this.environmentForDNS.put("java.naming.provider.url", DNSUrl);
            this.populateDCMap();
            String readOnlyString = realmConfig.getUserStoreProperty("ReadOnly");
            if (readOnlyString != null) {
                this.readOnly = Boolean.parseBoolean(readOnlyString);
            }
        }
        String rawConnectionURL = realmConfig.getUserStoreProperty("ConnectionURL");
        String connectionURL = null;
        if (rawConnectionURL != null) {
            String portInfo = rawConnectionURL.split(":")[2];
            String port = null;
            if (portInfo.contains("${") && portInfo.contains("}")) {
                port = Integer.toString(CarbonUtils.getPortFromServerConfig((String)portInfo));
            }
            connectionURL = port != null ? rawConnectionURL.replace(portInfo, port) : realmConfig.getUserStoreProperty("ConnectionURL");
        }
        String connectionName = realmConfig.getUserStoreProperty("ConnectionName");
        String connectionPassword = realmConfig.getUserStoreProperty("ConnectionPassword");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connection Name :: " + connectionName + "," + "Connection Password :: " + connectionPassword + "," + "Connection URL :: " + connectionURL));
        }
        this.environment = new Hashtable();
        this.environment.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.environment.put("java.naming.security.authentication", "simple");
        this.environment.put("org.wso2.carbon.context.RequestBaseContext", "true");
        if (connectionName != null) {
            this.environment.put("java.naming.security.principal", connectionName);
        }
        if (connectionPassword != null) {
            this.environment.put("java.naming.security.credentials", connectionPassword);
        }
        if (connectionURL != null) {
            this.environment.put("java.naming.provider.url", connectionURL);
        }
        this.environment.put("com.sun.jndi.ldap.connect.pool", "true");
        if (realmConfig.getUserStoreProperty("Referral") != null) {
            this.environment.put("java.naming.referral", realmConfig.getUserStoreProperty("Referral"));
        }
        if ((binaryAttribute = realmConfig.getUserStoreProperty("java.naming.ldap.attributes.binary")) != null) {
            this.environment.put("java.naming.ldap.attributes.binary", binaryAttribute);
        }
    }

    public DirContext getContext() throws UserStoreException {
        InitialDirContext context = null;
        if (this.dcMap == null) {
            try {
                context = new InitialDirContext(this.environment);
            }
            catch (NamingException e) {
                log.error((Object)("Error obtaining connection. " + e.getMessage()), (Throwable)e);
                log.error((Object)"Trying again to get connection.");
                try {
                    context = new InitialDirContext(this.environment);
                }
                catch (Exception e1) {
                    log.error((Object)("Error obtaining connection for the second time" + e.getMessage()), (Throwable)e);
                    throw new UserStoreException("Error obtaining connection. " + e.getMessage(), e);
                }
            }
        } else if (this.dcMap != null && this.dcMap.size() != 0) {
            try {
                Integer firstKey = this.dcMap.firstKey();
                SRVRecord firstRecord = (SRVRecord)this.dcMap.get(firstKey);
                this.environment.put("java.naming.provider.url", this.getLDAPURLFromSRVRecord(firstRecord));
                context = new InitialDirContext(this.environment);
            }
            catch (NamingException e) {
                log.error((Object)("Error obtaining connection to first Domain Controller." + e.getMessage()), (Throwable)e);
                log.info((Object)"Trying to connect with other Domain Controllers");
                for (Integer integer : this.dcMap.keySet()) {
                    try {
                        SRVRecord srv = (SRVRecord)this.dcMap.get(integer);
                        this.environment.put("java.naming.provider.url", this.getLDAPURLFromSRVRecord(srv));
                        context = new InitialDirContext(this.environment);
                        break;
                    }
                    catch (NamingException e1) {
                        if (integer != this.dcMap.lastKey()) continue;
                        log.error((Object)("Error obtaining connection for all " + integer + " Domain Controllers." + e.getMessage()), (Throwable)e);
                        throw new UserStoreException("Error obtaining connection. " + e.getMessage(), e);
                    }
                }
            }
        }
        return context;
    }

    public void updateCredential(String connectionPassword) {
        this.environment.put("java.naming.security.credentials", connectionPassword);
    }

    private void populateDCMap() throws UserStoreException {
        try {
            InitialDirContext dnsContext = new InitialDirContext(this.environmentForDNS);
            String DNSServiceName = "_ldap._tcp." + this.DNSDomainName;
            Attributes attributes = dnsContext.getAttributes(DNSServiceName, new String[]{"SRV"});
            Attribute srvRecords = attributes.get("SRV");
            NamingEnumeration<?> srvValues = srvRecords.getAll();
            this.dcMap = new TreeMap<Integer, SRVRecord>();
            while (srvValues.hasMore()) {
                String host;
                String port;
                String weight;
                String value = srvValues.next().toString();
                SRVRecord srvRecord = new SRVRecord();
                String[] valueItems = value.split(" ");
                String priority = valueItems[0];
                if (priority != null) {
                    int priorityInt = Integer.parseInt(priority);
                    srvRecord.setPriority(priorityInt);
                }
                if ((weight = valueItems[1]) != null) {
                    srvRecord.setWeight(Integer.parseInt(weight));
                }
                if ((port = valueItems[2]) != null) {
                    srvRecord.setPort(Integer.parseInt(port));
                }
                if ((host = valueItems[3]) != null) {
                    srvRecord.setHostName(host);
                }
                this.dcMap.put(srvRecord.getPriority(), srvRecord);
            }
            for (SRVRecord srvRecord : this.dcMap.values()) {
                Attributes hostAttributes = dnsContext.getAttributes(srvRecord.getHostName(), new String[]{"A"});
                Attribute hostRecord = hostAttributes.get("A");
                srvRecord.setHostIP((String)hostRecord.get());
            }
        }
        catch (NamingException e) {
            log.error((Object)("Error obtaining information from DNS Server" + e.getMessage()), (Throwable)e);
            throw new UserStoreException("Error obtaining information from DNS Server " + e.getMessage(), e);
        }
    }

    private String getLDAPURLFromSRVRecord(SRVRecord srvRecord) {
        String ldapURL = null;
        ldapURL = this.readOnly ? "ldap://" + srvRecord.getHostIP() + ":" + srvRecord.getPort() : "ldaps://" + srvRecord.getHostIP() + ":" + srvRecord.getPort();
        return ldapURL;
    }

    public LdapContext getContextWithCredentials(String userDN, String password) throws UserStoreException, NamingException, AuthenticationException {
        InitialLdapContext context = null;
        Hashtable<String, String> tempEnv = new Hashtable<String, String>();
        for (Object key : this.environment.keySet()) {
            tempEnv.put((String)key, (String)this.environment.get(key));
        }
        tempEnv.put("java.naming.security.principal", userDN);
        tempEnv.put("java.naming.security.credentials", password);
        if (this.dcMap == null) {
            context = new InitialLdapContext(tempEnv, null);
        } else if (this.dcMap != null && this.dcMap.size() != 0) {
            try {
                Integer firstKey = this.dcMap.firstKey();
                SRVRecord firstRecord = (SRVRecord)this.dcMap.get(firstKey);
                tempEnv.put("java.naming.provider.url", this.getLDAPURLFromSRVRecord(firstRecord));
                context = new InitialLdapContext(tempEnv, null);
            }
            catch (AuthenticationException e) {
                throw e;
            }
            catch (NamingException e) {
                log.error((Object)("Error obtaining connection to first Domain Controller." + e.getMessage()), (Throwable)e);
                log.info((Object)"Trying to connect with other Domain Controllers");
                for (Integer integer : this.dcMap.keySet()) {
                    try {
                        SRVRecord srv = (SRVRecord)this.dcMap.get(integer);
                        this.environment.put("java.naming.provider.url", this.getLDAPURLFromSRVRecord(srv));
                        context = new InitialLdapContext(this.environment, null);
                        break;
                    }
                    catch (AuthenticationException e2) {
                        throw e2;
                    }
                    catch (NamingException e1) {
                        if (integer != this.dcMap.lastKey()) continue;
                        log.error((Object)("Error obtaining connection for all " + integer + " Domain Controllers." + e1.getMessage()), (Throwable)e1);
                        throw new UserStoreException("Error obtaining connection. " + e1.getMessage(), e1);
                    }
                }
            }
        }
        return context;
    }
}

