/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.jdbc;

import java.util.ArrayList;
import org.wso2.carbon.user.api.Property;

public class JDBCUserStoreConstants {
    public static final ArrayList<Property> JDBC_UM_MANDATORY_PROPERTIES = new ArrayList();
    public static final ArrayList<Property> JDBC_UM_OPTIONAL_PROPERTIES = new ArrayList();
    public static final ArrayList<Property> JDBC_UM_ADVANCED_PROPERTIES = new ArrayList();

    private static void setProperty(String name, String value, String description) {
        Property property = new Property(name, value, description, null);
        JDBC_UM_OPTIONAL_PROPERTIES.add(property);
    }

    private static void setMandatoryProperty(String name, String value, String description) {
        Property property = new Property(name, value, description, null);
        JDBC_UM_MANDATORY_PROPERTIES.add(property);
    }

    private static void setAdvancedProperty(String name, String value, String description) {
        Property property = new Property(name, value, description, null);
        JDBC_UM_ADVANCED_PROPERTIES.add(property);
    }

    static {
        JDBCUserStoreConstants.setMandatoryProperty("driverName", "", "Full qualified driver name");
        JDBCUserStoreConstants.setMandatoryProperty("url", "", "URL of the user store database");
        JDBCUserStoreConstants.setMandatoryProperty("userName", "", "Username for the database");
        JDBCUserStoreConstants.setMandatoryProperty("password", "", "Password for the database");
        JDBCUserStoreConstants.setProperty("Disabled", "false", "Whether user store is disabled");
        JDBCUserStoreConstants.setProperty("MaxUserNameListLength", "100", "Maximum number of users retrieved at once");
        JDBCUserStoreConstants.setProperty("MaxRoleNameListLength", "100", "Maximum number of roles retrieved at once");
        JDBCUserStoreConstants.setProperty("UserRolesCacheEnabled", "true", "This is to indicate whether to cache the role list of a user");
        JDBCUserStoreConstants.setProperty("PasswordDigest", "SHA-256", "Password Hash method to use when storing user entries");
        JDBCUserStoreConstants.setProperty("ReadGroups", "true", "Specifies whether groups should be read from LDAP");
        JDBCUserStoreConstants.setProperty("ReadOnly", "false", "Indicates whether the user store of this realm operates in the user read only mode or not");
        JDBCUserStoreConstants.setProperty("IsEmailUserName", "false", "Indicates whether Email is used as user name (apply when realm operates in read only mode).");
        JDBCUserStoreConstants.setProperty("DomainCalculation", "default", "Can be either default or custom (apply when realm operates in read only mode)");
        JDBCUserStoreConstants.setProperty("StoreSaltedPassword", "true", "Indicates whether to salt the password");
        JDBCUserStoreConstants.setProperty("WriteGroups", "true", "Indicate whether write groups enabled");
        JDBCUserStoreConstants.setProperty("UserNameUniqueAcrossTenants", "false", "An attribute used for multi-tenancy");
        JDBCUserStoreConstants.setProperty("PasswordJavaRegEx", "^[\\S]{5,30}$", "A regular expression to validate passwords");
        JDBCUserStoreConstants.setProperty("PasswordJavaScriptRegEx", "^[\\S]{5,30}$", "The regular expression used by the font-end components for password validation");
        JDBCUserStoreConstants.setProperty("UsernameJavaRegEx", "^[\\S]{5,30}$", "A regular expression to validate user names");
        JDBCUserStoreConstants.setProperty("UsernameJavaScriptRegEx", "^[\\S]{5,30}$", "The regular expression used by the font-end components for username validation");
        JDBCUserStoreConstants.setProperty("RolenameJavaRegEx", "^[\\S]{5,30}$", "A regular expression to validate role names");
        JDBCUserStoreConstants.setProperty("RolenameJavaScriptRegEx", "^[\\S]{5,30}$", "The regular expression used by the font-end components for role name validation");
        JDBCUserStoreConstants.setProperty("SCIMEnabled", "false", "Whether SCIM is enabled for the user store");
        JDBCUserStoreConstants.setAdvancedProperty("SelectUserSQL", "SELECT * FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetRoleListSQL", "SELECT UM_ROLE_NAME, UM_TENANT_ID, UM_SHARED_ROLE FROM UM_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_TENANT_ID=? AND UM_SHARED_ROLE ='0' ORDER BY UM_ROLE_NAME", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetSharedRoleListSQL", "SELECT UM_ROLE_NAME, UM_TENANT_ID, UM_SHARED_ROLE FROM UM_ROLE WHERE UM_ROLE_NAME LIKE ? AND UM_SHARED_ROLE ='1' ORDER BY UM_ROLE_NAME", "");
        JDBCUserStoreConstants.setAdvancedProperty("UserFilterSQL", "SELECT UM_USER_NAME FROM UM_USER WHERE UM_USER_NAME LIKE ? AND UM_TENANT_ID=? ORDER BY UM_USER_NAME", "");
        JDBCUserStoreConstants.setAdvancedProperty("UserRoleSQL ", "SELECT UM_ROLE_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_USER.UM_USER_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("UserSharedRoleSQL", "SELECT UM_ROLE_NAME, UM_ROLE.UM_TENANT_ID, UM_SHARED_ROLE FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_USER.UM_USER_NAME = ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = ? ", "");
        JDBCUserStoreConstants.setAdvancedProperty("IsRoleExistingSQL", "SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetUserListOfRoleSQL", "SELECT UM_USER_NAME FROM UM_USER_ROLE, UM_ROLE, UM_USER WHERE UM_ROLE.UM_ROLE_NAME=? AND UM_USER.UM_ID=UM_USER_ROLE.UM_USER_ID AND UM_ROLE.UM_ID=UM_USER_ROLE.UM_ROLE_ID AND UM_USER_ROLE.UM_TENANT_ID=? AND UM_ROLE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetUserListOfSharedRoleSQL", "SELECT UM_USER_NAME FROM UM_SHARED_USER_ROLE INNER JOIN UM_USER ON UM_SHARED_USER_ROLE.UM_USER_ID = UM_USER.UM_ID INNER JOIN UM_ROLE ON UM_SHARED_USER_ROLE.UM_ROLE_ID = UM_ROLE.UM_ID WHERE UM_ROLE.UM_ROLE_NAME= ? AND UM_SHARED_USER_ROLE.UM_USER_TENANT_ID = UM_USER.UM_TENANT_ID AND UM_SHARED_USER_ROLE.UM_ROLE_TENANT_ID = UM_ROLE.UM_TENANT_ID", "");
        JDBCUserStoreConstants.setAdvancedProperty("IsUserExistingSQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetUserPropertiesForProfileSQL", "SELECT UM_ATTR_NAME, UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_NAME=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetUserPropertyForProfileSQL", "SELECT UM_ATTR_VALUE FROM UM_USER_ATTRIBUTE, UM_USER WHERE UM_USER.UM_ID = UM_USER_ATTRIBUTE.UM_USER_ID AND UM_USER.UM_USER_NAME=? AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetUserLisForPropertySQL", "SELECT UM_USER_NAME FROM UM_USER, UM_USER_ATTRIBUTE WHERE UM_USER_ATTRIBUTE.UM_USER_ID = UM_USER.UM_ID AND UM_USER_ATTRIBUTE.UM_ATTR_NAME =? AND UM_USER_ATTRIBUTE.UM_ATTR_VALUE =? AND UM_USER_ATTRIBUTE.UM_PROFILE_ID=? AND UM_USER_ATTRIBUTE.UM_TENANT_ID=? AND UM_USER.UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetProfileNamesSQL ", "SELECT DISTINCT UM_PROFILE_ID FROM UM_USER_ATTRIBUTE WHERE UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetUserProfileNamesSQL", "SELECT DISTINCT UM_PROFILE_ID FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetUserIDFromUserNameSQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetUserNameFromTenantIDSQL", "SELECT UM_USER_NAME FROM UM_USER WHERE UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("GetTenantIDFromUserNameSQL", "SELECT UM_TENANT_ID FROM UM_USER WHERE UM_USER_NAME=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddUserSQL", "INSERT INTO UM_USER (UM_USER_NAME, UM_USER_PASSWORD, UM_SALT_VALUE, UM_REQUIRE_CHANGE, UM_CHANGED_TIME, UM_TENANT_ID) VALUES (?, ?, ?, ?, ?, ?)", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddUserToRoleSQL", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?), ?)", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddRoleSQL", "INSERT INTO UM_ROLE (UM_ROLE_NAME, UM_TENANT_ID) VALUES (?, ?)", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddSharedRoleSQL", "UPDATE UM_ROLE SET UM_SHARED_ROLE = ? WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID = ?", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddRoleToUserSQL", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), ?)", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddSharedRoleToUserSQL", "INSERT INTO UM_SHARED_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_USER_TENANT_ID, UM_ROLE_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), ?, ?)", "");
        JDBCUserStoreConstants.setAdvancedProperty("RemoveUserFromSharedRoleSQL", "DELETE FROM UM_SHARED_USER_ROLE WHERE   UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_USER_TENANT_ID=? AND UM_ROLE_TENANT_ID = ?", "");
        JDBCUserStoreConstants.setAdvancedProperty("RemoveUserFromRoleSQL", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("RemoveRoleFromUserSQL", "DELETE FROM UM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("DeleteRoleSQL ", "DELETE FROM UM_ROLE WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("OnDeleteRoleRemoveUserRoleMappingSQL ", "DELETE FROM UM_USER_ROLE WHERE UM_ROLE_ID=(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("DeleteUserSQL", "DELETE FROM UM_USER WHERE UM_USER_NAME = ? AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("OnDeleteUserRemoveUserRoleMappingSQL", "DELETE FROM UM_USER_ROLE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("OnDeleteUserRemoveUserAttributeSQL ", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("UpdateUserPasswordSQL", "UPDATE UM_USER SET UM_USER_PASSWORD= ?, UM_SALT_VALUE=?, UM_REQUIRE_CHANGE=?, UM_CHANGED_TIME=? WHERE UM_USER_NAME= ? AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("UpdateRoleNameSQL", "UPDATE UM_ROLE set UM_ROLE_NAME=? WHERE UM_ROLE_NAME = ? AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddUserPropertySQL ", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) VALUES ((SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), ?, ?, ?, ?)", "");
        JDBCUserStoreConstants.setAdvancedProperty("UpdateUserPropertySQL ", "UPDATE UM_USER_ATTRIBUTE SET UM_ATTR_VALUE=? WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("DeleteUserPropertySQL ", "DELETE FROM UM_USER_ATTRIBUTE WHERE UM_USER_ID=(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?) AND UM_ATTR_NAME=? AND UM_PROFILE_ID=? AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("UserNameUniqueAcrossTenantsSQL", "SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("IsDomainExistingSQL", "SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_DOMAIN_NAME=? AND UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddDomainSQL", "INSERT INTO UM_DOMAIN (UM_DOMAIN_NAME, UM_TENANT_ID) VALUES (?, ?)", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddUserToRoleSQL-mssql", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(?)", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddRoleToUserSQL-mssql", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?),(SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), (?)", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddUserPropertySQL-mssql", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) SELECT (SELECT UM_ID FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?), (?), (?), (?), (?)", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddUserToRoleSQL-openedge", "INSERT INTO UM_USER_ROLE (UM_USER_ID, UM_ROLE_ID, UM_TENANT_ID) SELECT UU.UM_ID, UR.UM_ID, ? FROM UM_USER UU, UM_ROLE UR WHERE UU.UM_USER_NAME=? AND UU.UM_TENANT_ID=? AND UR.UM_ROLE_NAME=? AND UR.UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddRoleToUserSQL-openedge", "INSERT INTO UM_USER_ROLE (UM_ROLE_ID, UM_USER_ID, UM_TENANT_ID) SELECT UR.UM_ID, UU.UM_ID, ? FROM UM_ROLE UR, UM_USER UU WHERE UR.UM_ROLE_NAME=? AND UR.UM_TENANT_ID=? AND UU.UM_USER_NAME=? AND UU.UM_TENANT_ID=?", "");
        JDBCUserStoreConstants.setAdvancedProperty("AddUserPropertySQL-openedge", "INSERT INTO UM_USER_ATTRIBUTE (UM_USER_ID, UM_ATTR_NAME, UM_ATTR_VALUE, UM_PROFILE_ID, UM_TENANT_ID) SELECT UM_ID, ?, ?, ?, ? FROM UM_USER WHERE UM_USER_NAME=? AND UM_TENANT_ID=?", "");
    }
}

