/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.handler.MessageContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.handler.AttachmentsAdapter;
import org.apache.axis2.jaxws.handler.SOAPHeadersAdapter;
import org.apache.axis2.jaxws.handler.TransportHeadersAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseMessageContext
implements javax.xml.ws.handler.MessageContext {
    private static final Log log = LogFactory.getLog(BaseMessageContext.class);
    protected MessageContext messageCtx;

    protected BaseMessageContext(MessageContext messageCtx) {
        this.messageCtx = messageCtx;
        AttachmentsAdapter.install(messageCtx);
        TransportHeadersAdapter.install(messageCtx);
        SOAPHeadersAdapter.install(messageCtx);
    }

    @Override
    public void clear() {
        this.messageCtx.getMEPContext().clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.messageCtx.getMEPContext().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.messageCtx.getMEPContext().containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.messageCtx.getMEPContext().entrySet();
    }

    @Override
    public Object get(Object key) {
        TransportHeadersAdapter adapter;
        Object returnValue = null;
        returnValue = this.shouldPropertySpanMEP(key) ? this.messageCtx.getMEPContext().get(key) : this.messageCtx.getProperty((String)key);
        if (returnValue != null && returnValue instanceof TransportHeadersAdapter && (adapter = (TransportHeadersAdapter)returnValue).isEmpty()) {
            return null;
        }
        return returnValue;
    }

    private boolean shouldPropertySpanMEP(Object key) {
        boolean shouldSpan = true;
        String keyString = (String)key;
        Boolean outbound = (Boolean)this.messageCtx.getMEPContext().get("javax.xml.ws.handler.message.outbound");
        if (outbound != null && !outbound.booleanValue() && "javax.xml.ws.http.request.headers".equals(keyString)) {
            shouldSpan = false;
        }
        return shouldSpan;
    }

    @Override
    public boolean isEmpty() {
        return this.messageCtx.getMEPContext().isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.messageCtx.getMEPContext().keySet();
    }

    @Override
    public Object put(String key, Object value) {
        return this.messageCtx.getMEPContext().put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        this.messageCtx.getMEPContext().putAll(t);
    }

    @Override
    public Object remove(Object key) {
        return this.messageCtx.getMEPContext().remove(key);
    }

    @Override
    public int size() {
        return this.messageCtx.getMEPContext().size();
    }

    @Override
    public Collection<Object> values() {
        return this.messageCtx.getMEPContext().values();
    }

    @Override
    public MessageContext.Scope getScope(String s) {
        return this.messageCtx.getMEPContext().getScope(s);
    }

    @Override
    public void setScope(String s, MessageContext.Scope scope) {
        this.messageCtx.getMEPContext().setScope(s, scope);
    }
}

