/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.pkcs;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.util.pkcs.PEMFormatUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class KeyUtil {
    public static final String BEGIN_RSA_PRIVATE_KEY = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String END_RSA_PRIVATE_KEY = "-----END RSA PRIVATE KEY-----";
    public static final String BEGIN_PRIVATE_KEY = "-----BEGIN PRIVATE KEY-----";
    public static final String END_PRIVATE_KEY = "-----END PRIVATE KEY-----";
    public static final String BEGIN_PUBLIC_KEY = "-----BEGIN PUBLIC KEY-----";
    public static final String END_PUBLIC_KEY = "-----END PUBLIC KEY-----";
    static int keyLength = 2048;
    static KeyPairGenerator keyPairGenerator;
    protected static String keyAlgorithm;
    protected static KeyFactory keyFactory;

    public static void toPKCS1PEM(PrivateKey privateKey, Writer writer) throws IOException {
        String pem = KeyUtil.toPKCS1PEM(privateKey);
        writer.write(pem);
        writer.flush();
    }

    public static void toPKCS1PEM(PrivateKey privateKey, OutputStream out) throws IOException {
        PrintStream printStream = new PrintStream(out);
        printStream.print(KeyUtil.toPKCS1PEM(privateKey));
        printStream.flush();
    }

    public static String toPKCS1PEM(PrivateKey privateKey) throws IOException {
        byte[] bytes = privateKey.getEncoded();
        return PEMFormatUtil.delimitBody(Base64.encodeBase64String((byte[])bytes), BEGIN_RSA_PRIVATE_KEY, END_RSA_PRIVATE_KEY);
    }

    public static void toX509PEM(PublicKey publicKey, Writer writer) throws IOException {
        writer.write(KeyUtil.toX509PEM(publicKey));
        writer.flush();
    }

    public static String toX509PEM(PublicKey publicKey) {
        byte[] bytes = publicKey.getEncoded();
        return PEMFormatUtil.delimitBody(Base64.encodeBase64String((byte[])bytes), BEGIN_PUBLIC_KEY, END_PUBLIC_KEY);
    }

    public static byte[] toDER(PrivateKey privateKey) {
        return privateKey.getEncoded();
    }

    public static byte[] toDER(PublicKey publicKey) {
        return publicKey.getEncoded();
    }

    public static byte[] privateToDER(KeyPair keyPair) {
        return KeyUtil.toDER(keyPair.getPrivate());
    }

    public static byte[] publicToDER(KeyPair keyPair) {
        return KeyUtil.toDER(keyPair.getPublic());
    }

    public static PrivateKey fromPKCS8DER(byte[] encodedPrivate) {
        try {
            PKCS8EncodedKeySpec encodedPrivatePKCS8 = new PKCS8EncodedKeySpec(encodedPrivate);
            return KeyUtil.getKeyFactory().generatePrivate(encodedPrivatePKCS8);
        }
        catch (Exception e) {
            throw new GeneralException("Could not decode private key", (Throwable)e);
        }
    }

    public static String toPKCS8PEM(PrivateKey privateKey) {
        return PEMFormatUtil.delimitBody(privateKey.getEncoded(), BEGIN_PRIVATE_KEY, END_PRIVATE_KEY);
    }

    public static void toPKCS8PEM(PrivateKey privateKey, Writer writer) throws IOException {
        writer.write(KeyUtil.toPKCS8PEM(privateKey));
        writer.flush();
    }

    public static PrivateKey fromPKCS8PEM(String pem) throws GeneralException {
        return KeyUtil.fromPKCS8DER(PEMFormatUtil.getBodyBytes(pem, BEGIN_PRIVATE_KEY, END_PRIVATE_KEY));
    }

    public static PublicKey fromX509PEM(String encodedPublic) {
        return KeyUtil.fromX509DER(PEMFormatUtil.getBodyBytes(encodedPublic, BEGIN_PUBLIC_KEY, END_PUBLIC_KEY));
    }

    public static PublicKey fromX509DER(byte[] encodedPublic) {
        X509EncodedKeySpec x = new X509EncodedKeySpec(encodedPublic);
        try {
            return KeyUtil.getKeyFactory().generatePublic(x);
        }
        catch (Exception e) {
            throw new GeneralException("Could not decode public key", (Throwable)e);
        }
    }

    public static int getKeyLength() {
        return keyLength;
    }

    public static void setKeyLength(int length) {
        keyLength = length;
    }

    public static KeyPairGenerator getKeyPairGenerator() throws NoSuchProviderException, NoSuchAlgorithmException {
        if (keyPairGenerator == null) {
            keyPairGenerator = KeyPairGenerator.getInstance(KeyUtil.getKeyAlgorithm());
            keyPairGenerator.initialize(KeyUtil.getKeyLength());
        }
        return keyPairGenerator;
    }

    public static void setKeyPairGenerator(KeyPairGenerator generator) {
        keyPairGenerator = generator;
    }

    public static KeyPair generateKeyPair() throws NoSuchProviderException, NoSuchAlgorithmException {
        return KeyUtil.getKeyPairGenerator().generateKeyPair();
    }

    public static String getKeyAlgorithm() {
        return keyAlgorithm;
    }

    public static void setKeyAlgorithm(String algorithm) {
        keyAlgorithm = algorithm;
    }

    public static KeyFactory getKeyFactory() throws NoSuchAlgorithmException {
        if (keyFactory == null) {
            keyFactory = KeyFactory.getInstance(KeyUtil.getKeyAlgorithm());
        }
        return keyFactory;
    }

    public static PrivateKey fromPKCS8PEM(Reader reader) throws IOException {
        return KeyUtil.fromPKCS8PEM(PEMFormatUtil.readerToString(reader));
    }

    public static PublicKey fromX509PEM(Reader reader) throws IOException {
        return KeyUtil.fromX509PEM(PEMFormatUtil.readerToString(reader));
    }

    static {
        keyAlgorithm = "RSA";
    }
}

