/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import jakarta.jms.JMSException;
import jakarta.jms.MessageEOFException;
import jakarta.jms.StreamMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class StreamMessageInputStream
extends InputStream {
    private final Lock lock = new ReentrantLock();
    private final StreamMessage message;
    private volatile boolean eof;

    public StreamMessageInputStream(StreamMessage message) {
        this.message = message;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.message.readByte();
        }
        catch (MessageEOFException e) {
            this.eof = true;
            return -1;
        }
        catch (JMSException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] array) throws IOException {
        return this.doRead(array);
    }

    private int doRead(byte[] array) throws IOException {
        try {
            int num = this.message.readBytes(array);
            if (num < 0) {
                num = this.message.readBytes(array);
            }
            this.eof = num < 0;
            return num;
        }
        catch (MessageEOFException e) {
            this.eof = true;
            return -1;
        }
        catch (JMSException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] array, int off, int len) throws IOException {
        return this.doRead(array);
    }

    @Override
    public void reset() throws IOException {
        this.lock.lock();
        try {
            this.message.reset();
        }
        catch (JMSException e) {
            throw new IOException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int available() throws IOException {
        return this.eof ? 0 : 1;
    }
}

