/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.namespace.delete;

import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NamespaceCleanUp
extends ManagerRepo {
    private static final Logger log = LoggerFactory.getLogger(NamespaceCleanUp.class);
    private static final long serialVersionUID = 1L;
    private NamespaceId namespaceId;

    public NamespaceCleanUp(NamespaceId namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    public long isReady(long tid, Manager manager) {
        return 0L;
    }

    @Override
    public Repo<Manager> call(long id, Manager manager) {
        try {
            manager.getTableManager().removeNamespace(this.namespaceId);
        }
        catch (Exception e) {
            log.error("Failed to find namespace in zookeeper", (Throwable)e);
        }
        manager.getContext().clearTableListCache();
        try {
            manager.getContext().getSecurityOperation().deleteNamespace(manager.getContext().rpcCreds(), this.namespaceId);
        }
        catch (ThriftSecurityException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
        }
        Utils.unreserveNamespace(manager, this.namespaceId, id, true);
        log.debug("Deleted namespace " + this.namespaceId);
        return null;
    }

    @Override
    public void undo(long tid, Manager environment) {
    }
}

