/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.accumulo.core.conf.DeprecatedPropertyUtil;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.PropertyType;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.SystemPropKey;
import org.apache.accumulo.server.util.PropUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropUtil {
    private static final Logger log = LoggerFactory.getLogger(SystemPropUtil.class);

    public static void setSystemProperty(ServerContext context, String property, String value) throws IllegalArgumentException {
        SystemPropKey key = SystemPropKey.of(context);
        context.getPropStore().putAll(key, Map.of(SystemPropUtil.validateSystemProperty(key, property, value), value));
    }

    public static void modifyProperties(ServerContext context, long version, Map<String, String> properties) throws IllegalArgumentException {
        SystemPropKey key = SystemPropKey.of(context);
        Map<String, String> checkedProperties = properties.entrySet().stream().collect(Collectors.toMap(entry -> SystemPropUtil.validateSystemProperty(key, (String)entry.getKey(), (String)entry.getValue()), Map.Entry::getValue));
        context.getPropStore().replaceAll(key, version, checkedProperties);
    }

    public static void removeSystemProperty(ServerContext context, String property) {
        String resolved = DeprecatedPropertyUtil.getReplacementName((String)property, (log, replacement) -> log.warn("{} was deprecated and will be removed in a future release; assuming user meant its replacement {} and will remove that instead", (Object)property, replacement));
        SystemPropUtil.removePropWithoutDeprecationWarning(context, resolved);
    }

    public static void removePropWithoutDeprecationWarning(ServerContext context, String property) {
        context.getPropStore().removeProperties(SystemPropKey.of(context), List.of(property));
    }

    private static String validateSystemProperty(SystemPropKey key, String property, String value) throws IllegalArgumentException {
        String original = property;
        if (!Property.isValidZooPropertyKey((String)(property = DeprecatedPropertyUtil.getReplacementName((String)property, (log, replacement) -> log.warn("{} was deprecated and will be removed in a future release; setting its replacement {} instead", (Object)original, replacement))))) {
            IllegalArgumentException iae = new IllegalArgumentException("Zookeeper property is not mutable: " + property);
            SystemPropUtil.log.trace("Encountered error setting zookeeper property", (Throwable)iae);
            throw iae;
        }
        if (!Property.isValidProperty((String)property, (String)value)) {
            IllegalArgumentException iae = new IllegalArgumentException("Property " + property + " with value: " + value + " is not valid");
            SystemPropUtil.log.trace("Encountered error setting zookeeper property", (Throwable)iae);
            throw iae;
        }
        if (Property.isValidTablePropertyKey((String)property)) {
            PropUtil.validateProperties(key, Map.of(property, value));
        }
        Property foundProp = null;
        for (Property prop : Property.values()) {
            if ((prop.getType() != PropertyType.PREFIX || !property.startsWith(prop.getKey())) && !prop.getKey().equals(property)) continue;
            foundProp = prop;
            break;
        }
        if (foundProp == null || foundProp.getType() != PropertyType.PREFIX && !foundProp.getType().isValidFormat(value)) {
            IllegalArgumentException iae = new IllegalArgumentException("Ignoring property " + property + " it is either null or in an invalid format");
            SystemPropUtil.log.trace("Attempted to set zookeeper property.  Value is either null or invalid", (Throwable)iae);
            throw iae;
        }
        return property;
    }
}

