/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.metadata.ReferencedTabletFile;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeUtil {
    private static final Logger log = LoggerFactory.getLogger(VolumeUtil.class);

    public static String removeTrailingSlash(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static Path removeTrailingSlash(Path path) {
        String pathStr = path.toString();
        if (pathStr.endsWith("/")) {
            return new Path(VolumeUtil.removeTrailingSlash(pathStr));
        }
        return path;
    }

    public static Path switchVolume(String path, VolumeManager.FileType ft, List<Pair<Path, Path>> replacements) {
        if (replacements.isEmpty()) {
            log.trace("Not switching volume because there are no replacements");
            return null;
        }
        Path p = new Path(path);
        Path volume = VolumeUtil.removeTrailingSlash(ft.getVolume(p));
        for (Pair<Path, Path> pair : replacements) {
            Path key = VolumeUtil.removeTrailingSlash((Path)pair.getFirst());
            if (!key.equals((Object)volume)) continue;
            Path replacement = new Path((Path)pair.getSecond(), ft.removeVolume(p));
            log.trace("Replacing {} with {}", (Object)path, (Object)replacement);
            return replacement;
        }
        log.trace("Could not find replacement for {} at {}", (Object)ft, (Object)path);
        return null;
    }

    private static LogEntry switchVolumes(LogEntry le, List<Pair<Path, Path>> replacements) {
        String switchedString;
        Path switchedPath = VolumeUtil.switchVolume(le.filename, VolumeManager.FileType.WAL, replacements);
        int numSwitched = 0;
        if (switchedPath != null) {
            switchedString = switchedPath.toString();
            ++numSwitched;
        } else {
            switchedString = le.filename;
        }
        if (numSwitched == 0) {
            log.trace("Did not switch {}", (Object)le);
            return null;
        }
        LogEntry newLogEntry = le.switchFile(switchedString);
        log.trace("Switched {} to {}", (Object)le, (Object)newLogEntry);
        return newLogEntry;
    }

    public static TabletFiles updateTabletVolumes(ServerContext context, ServiceLock zooLock, KeyExtent extent, TabletFiles tabletFiles) {
        List<Pair<Path, Path>> replacements = context.getVolumeReplacements();
        if (replacements.isEmpty()) {
            return tabletFiles;
        }
        log.trace("Using volume replacements: {}", replacements);
        ArrayList<LogEntry> logsToRemove = new ArrayList<LogEntry>();
        ArrayList<LogEntry> logsToAdd = new ArrayList<LogEntry>();
        ArrayList<StoredTabletFile> filesToRemove = new ArrayList<StoredTabletFile>();
        TreeMap<ReferencedTabletFile, DataFileValue> filesToAdd = new TreeMap<ReferencedTabletFile, DataFileValue>();
        TabletFiles ret = new TabletFiles();
        for (LogEntry logEntry : tabletFiles.logEntries) {
            LogEntry switchedLogEntry = VolumeUtil.switchVolumes(logEntry, replacements);
            if (switchedLogEntry != null) {
                logsToRemove.add(logEntry);
                logsToAdd.add(switchedLogEntry);
                ret.logEntries.add(switchedLogEntry);
                log.debug("Replacing volume {} : {} -> {}", new Object[]{extent, logEntry.filename, switchedLogEntry.filename});
                continue;
            }
            ret.logEntries.add(logEntry);
        }
        for (Map.Entry entry : tabletFiles.datafiles.entrySet()) {
            String metaPath = ((StoredTabletFile)entry.getKey()).getMetaUpdateDelete();
            Path switchedPath = VolumeUtil.switchVolume(metaPath, VolumeManager.FileType.TABLE, replacements);
            if (switchedPath != null) {
                filesToRemove.add((StoredTabletFile)entry.getKey());
                ReferencedTabletFile switchedFile = new ReferencedTabletFile(switchedPath);
                filesToAdd.put(switchedFile, (DataFileValue)entry.getValue());
                ret.datafiles.put(switchedFile.insert(), (DataFileValue)entry.getValue());
                log.debug("Replacing volume {} : {} -> {}", new Object[]{extent, metaPath, switchedPath});
                continue;
            }
            ret.datafiles.put((StoredTabletFile)entry.getKey(), (DataFileValue)entry.getValue());
        }
        if (logsToRemove.size() + filesToRemove.size() > 0) {
            MetadataTableUtil.updateTabletVolumes(extent, logsToRemove, logsToAdd, filesToRemove, filesToAdd, zooLock, context);
        }
        ret.dirName = tabletFiles.dirName;
        return ret;
    }

    public static class TabletFiles {
        public String dirName;
        public List<LogEntry> logEntries;
        public SortedMap<StoredTabletFile, DataFileValue> datafiles;

        public TabletFiles() {
            this.logEntries = new ArrayList<LogEntry>();
            this.datafiles = new TreeMap<StoredTabletFile, DataFileValue>();
        }

        public TabletFiles(String dirName, List<LogEntry> logEntries, SortedMap<StoredTabletFile, DataFileValue> datafiles) {
            this.dirName = dirName;
            this.logEntries = logEntries;
            this.datafiles = datafiles;
        }
    }
}

