/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import com.google.common.util.concurrent.AtomicLongMap;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.rfile.MetricsGatherer;
import org.apache.accumulo.core.file.rfile.VisibilityMetric;
import org.apache.hadoop.io.Text;

public class VisMetricsGatherer
implements MetricsGatherer<Map<String, ArrayList<VisibilityMetric>>> {
    private static final String KEY_HASH_ALGORITHM = "SHA-256";
    protected Map<String, AtomicLongMap<String>> metric = new HashMap<String, AtomicLongMap<String>>();
    protected Map<String, AtomicLongMap<String>> blocks = new HashMap<String, AtomicLongMap<String>>();
    protected ArrayList<Long> numEntries = new ArrayList();
    protected ArrayList<Integer> numBlocks = new ArrayList();
    private ArrayList<String> inBlock = new ArrayList();
    protected ArrayList<String> localityGroups = new ArrayList();
    private int numLG = 0;
    private Map<String, ArrayList<ByteSequence>> localityGroupCF;

    @Override
    public void init(Map<String, ArrayList<ByteSequence>> cf) {
        this.localityGroupCF = cf;
    }

    @Override
    public void startLocalityGroup(Text oneCF) {
        String name = null;
        ArrayByteSequence cf = new ArrayByteSequence(oneCF.toString());
        for (Map.Entry<String, ArrayList<ByteSequence>> entry : this.localityGroupCF.entrySet()) {
            if (!entry.getValue().contains(cf)) continue;
            if (entry.getKey() == null) break;
            name = entry.getKey().toString();
            break;
        }
        this.localityGroups.add(name);
        this.metric.put(name, (AtomicLongMap<String>)AtomicLongMap.create(new HashMap()));
        this.blocks.put(name, (AtomicLongMap<String>)AtomicLongMap.create(new HashMap()));
        ++this.numLG;
        this.numEntries.add(0L);
        this.numBlocks.add(0);
    }

    @Override
    public void addMetric(Key key, Value val) {
        String myMetric = key.getColumnVisibility().toString();
        String currLG = this.localityGroups.get(this.numLG - 1);
        if (this.metric.get(currLG).containsKey((Object)myMetric)) {
            this.metric.get(currLG).getAndIncrement((Object)myMetric);
        } else {
            this.metric.get(currLG).put((Object)myMetric, 1L);
        }
        this.numEntries.set(this.numLG - 1, this.numEntries.get(this.numLG - 1) + 1L);
        if (!this.inBlock.contains(myMetric) && this.blocks.get(currLG).containsKey((Object)myMetric)) {
            this.blocks.get(currLG).incrementAndGet((Object)myMetric);
            this.inBlock.add(myMetric);
        } else if (!this.inBlock.contains(myMetric) && !this.blocks.get(currLG).containsKey((Object)myMetric)) {
            this.blocks.get(currLG).put((Object)myMetric, 1L);
            this.inBlock.add(myMetric);
        }
    }

    @Override
    public void startBlock() {
        this.inBlock.clear();
        this.numBlocks.set(this.numLG - 1, this.numBlocks.get(this.numLG - 1) + 1);
    }

    @Override
    public void printMetrics(boolean hash, String metricWord, PrintStream out) {
        for (int i = 0; i < this.numLG; ++i) {
            String lGName = this.localityGroups.get(i);
            out.print("Locality Group: ");
            if (lGName == null) {
                out.println("<DEFAULT>");
            } else {
                out.println(this.localityGroups.get(i));
            }
            out.printf("%-27s", metricWord);
            out.println("Number of keys\t   Percent of keys\tNumber of blocks\tPercent of blocks");
            for (Map.Entry entry : this.metric.get(lGName).asMap().entrySet()) {
                if (hash) {
                    String encodedKey = "";
                    try {
                        byte[] encodedBytes = MessageDigest.getInstance(KEY_HASH_ALGORITHM).digest(((String)entry.getKey()).getBytes(StandardCharsets.UTF_8));
                        encodedKey = new String(encodedBytes, StandardCharsets.UTF_8);
                    }
                    catch (NoSuchAlgorithmException e) {
                        out.println("Failed to convert key to SHA-256 hash: " + e.getMessage());
                    }
                    out.printf("%-20s", encodedKey.substring(0, 8));
                } else {
                    out.printf("%-20s", entry.getKey());
                }
                out.print("\t\t" + entry.getValue() + "\t\t\t");
                out.printf("%.2f", (double)((Long)entry.getValue()).longValue() / (double)this.numEntries.get(i).longValue() * 100.0);
                out.print("%\t\t\t");
                long blocksIn = this.blocks.get(lGName).get((Object)((String)entry.getKey()));
                out.print(blocksIn + "\t\t   ");
                out.printf("%.2f", (double)blocksIn / (double)this.numBlocks.get(i).intValue() * 100.0);
                out.print("%");
                out.println("");
            }
            out.println("Number of keys: " + this.numEntries.get(i));
            out.println();
        }
    }

    @Override
    public Map<String, ArrayList<VisibilityMetric>> getMetrics() {
        HashMap<String, ArrayList<VisibilityMetric>> getMetrics = new HashMap<String, ArrayList<VisibilityMetric>>();
        for (int i = 0; i < this.numLG; ++i) {
            String lGName = this.localityGroups.get(i);
            ArrayList<VisibilityMetric> rows = new ArrayList<VisibilityMetric>();
            for (Map.Entry entry : this.metric.get(lGName).asMap().entrySet()) {
                long vis = (Long)entry.getValue();
                double visPer = (double)((Long)entry.getValue()).longValue() / (double)this.numEntries.get(i).longValue() * 100.0;
                long blocksIn = this.blocks.get(lGName).get((Object)((String)entry.getKey()));
                double blocksPer = (double)blocksIn / (double)this.numBlocks.get(i).intValue() * 100.0;
                rows.add(new VisibilityMetric((String)entry.getKey(), vis, visPer, blocksIn, blocksPer));
            }
            getMetrics.put(lGName, rows);
        }
        return getMetrics;
    }
}

