/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoop.mapreduce;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.accumulo.hadoop.mapreduce.InputFormatBuilder;
import org.apache.accumulo.hadoopImpl.mapreduce.AccumuloRecordReader;
import org.apache.accumulo.hadoopImpl.mapreduce.InputFormatBuilderImpl;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class AccumuloRowInputFormat
extends InputFormat<Text, PeekingIterator<Map.Entry<Key, Value>>> {
    private static final Class<AccumuloRowInputFormat> CLASS = AccumuloRowInputFormat.class;

    public RecordReader<Text, PeekingIterator<Map.Entry<Key, Value>>> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return new AccumuloRecordReader<Text, PeekingIterator<Map.Entry<Key, Value>>>(CLASS){
            RowIterator rowIterator;

            @Override
            public void initialize(InputSplit inSplit, TaskAttemptContext attempt) throws IOException {
                super.initialize(inSplit, attempt);
                this.rowIterator = new RowIterator(this.scannerIterator);
                this.currentK = new Text();
                this.currentV = null;
            }

            public boolean nextKeyValue() {
                if (!this.rowIterator.hasNext()) {
                    return false;
                }
                this.currentV = new PeekingIterator(this.rowIterator.next());
                this.numKeysRead = this.rowIterator.getKVCount();
                this.currentKey = (Key)((Map.Entry)((PeekingIterator)this.currentV).peek()).getKey();
                this.currentK = new Text(this.currentKey.getRow());
                return true;
            }
        };
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        return AccumuloRecordReader.getSplits(context, CLASS);
    }

    public static InputFormatBuilder.ClientParams<Job> configure() {
        return new InputFormatBuilderImpl<Job>(CLASS);
    }
}

