/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.manager;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.manager.thrift.DeadServer;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.manager.thrift.TabletServerStatus;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.logs.DeadLoggerInformation;
import org.apache.accumulo.monitor.rest.logs.DeadLoggerList;
import org.apache.accumulo.monitor.rest.manager.ManagerInformation;
import org.apache.accumulo.monitor.rest.tservers.BadTabletServerInformation;
import org.apache.accumulo.monitor.rest.tservers.BadTabletServers;
import org.apache.accumulo.monitor.rest.tservers.DeadServerInformation;
import org.apache.accumulo.monitor.rest.tservers.DeadServerList;
import org.apache.accumulo.monitor.rest.tservers.ServerShuttingDownInformation;
import org.apache.accumulo.monitor.rest.tservers.ServersShuttingDown;
import org.apache.accumulo.server.manager.state.TabletServerState;

@Path(value="/manager")
@Produces(value={"application/json", "application/xml"})
public class ManagerResource {
    public static final String NO_MANAGERS = "No Managers running";
    @Inject
    private Monitor monitor;

    @GET
    public ManagerInformation getTables() {
        return ManagerResource.getTables(this.monitor);
    }

    public static ManagerInformation getTables(Monitor monitor) {
        ManagerInformation managerInformation;
        ManagerMonitorInfo mmi = monitor.getMmi();
        if (mmi != null) {
            GCStatus gcStatusObj = monitor.getGcStatus();
            String gcStatus = "Waiting";
            String label = "";
            if (gcStatusObj != null) {
                long start = 0L;
                if (gcStatusObj.current.started != 0L || gcStatusObj.currentLog.started != 0L) {
                    start = Math.max(gcStatusObj.current.started, gcStatusObj.currentLog.started);
                    label = "Running";
                } else if (gcStatusObj.lastLog.finished != 0L) {
                    start = gcStatusObj.lastLog.finished;
                }
                if (start != 0L) {
                    gcStatus = String.valueOf(start);
                }
            } else {
                gcStatus = "Down";
            }
            ArrayList<String> tservers = new ArrayList<String>();
            for (TabletServerStatus up : mmi.tServerInfo) {
                tservers.add(up.name);
            }
            for (DeadServer down : mmi.deadTabletServers) {
                tservers.add(down.server);
            }
            List managers = monitor.getContext().getManagerLocations();
            String manager = managers.isEmpty() ? "Down" : AddressUtil.parseAddress((String)((String)managers.get(0)), (boolean)false).getHost();
            int onlineTabletServers = mmi.tServerInfo.size();
            int totalTabletServers = tservers.size();
            int tablets = monitor.getTotalTabletCount();
            int unassignedTablets = mmi.unassignedTablets;
            long entries = monitor.getTotalEntries();
            double ingest = monitor.getTotalIngestRate();
            double entriesRead = monitor.getTotalScanRate();
            double entriesReturned = monitor.getTotalQueryRate();
            long holdTime = monitor.getTotalHoldTime();
            double osLoad = ManagementFactory.getOperatingSystemMXBean().getSystemLoadAverage();
            int tables = monitor.getTotalTables();
            int deadTabletServers = mmi.deadTabletServers.size();
            long lookups = monitor.getTotalLookups();
            long uptime = System.currentTimeMillis() - monitor.getStartTime();
            managerInformation = new ManagerInformation(manager, onlineTabletServers, totalTabletServers, gcStatus, tablets, unassignedTablets, entries, ingest, entriesRead, entriesReturned, holdTime, osLoad, tables, deadTabletServers, lookups, uptime, label, ManagerResource.getGoalState(monitor), ManagerResource.getState(monitor), ManagerResource.getNumBadTservers(monitor), ManagerResource.getServersShuttingDown(monitor), ManagerResource.getDeadTservers(monitor), ManagerResource.getDeadLoggers(monitor));
        } else {
            managerInformation = new ManagerInformation();
        }
        return managerInformation;
    }

    public static String getState(Monitor monitor) {
        ManagerMonitorInfo mmi = monitor.getMmi();
        if (mmi == null) {
            return NO_MANAGERS;
        }
        return mmi.state.toString();
    }

    public static String getGoalState(Monitor monitor) {
        ManagerMonitorInfo mmi = monitor.getMmi();
        if (mmi == null) {
            return NO_MANAGERS;
        }
        return mmi.goalState.name();
    }

    public static DeadServerList getDeadTservers(Monitor monitor) {
        ManagerMonitorInfo mmi = monitor.getMmi();
        if (mmi == null) {
            return new DeadServerList();
        }
        DeadServerList deadServers = new DeadServerList();
        for (DeadServer dead : mmi.deadTabletServers) {
            deadServers.addDeadServer(new DeadServerInformation(dead.server, dead.lastStatus, dead.status));
        }
        return deadServers;
    }

    public static DeadLoggerList getDeadLoggers(Monitor monitor) {
        ManagerMonitorInfo mmi = monitor.getMmi();
        if (mmi == null) {
            return new DeadLoggerList();
        }
        DeadLoggerList deadLoggers = new DeadLoggerList();
        for (DeadServer dead : mmi.deadTabletServers) {
            deadLoggers.addDeadLogger(new DeadLoggerInformation(dead.server, dead.lastStatus, dead.status));
        }
        return deadLoggers;
    }

    public static BadTabletServers getNumBadTservers(Monitor monitor) {
        ManagerMonitorInfo mmi = monitor.getMmi();
        if (mmi == null) {
            return new BadTabletServers();
        }
        Map badServers = mmi.getBadTServers();
        if (badServers == null || badServers.isEmpty()) {
            return new BadTabletServers();
        }
        BadTabletServers readableBadServers = new BadTabletServers();
        for (Map.Entry badServer : badServers.entrySet()) {
            try {
                TabletServerState state = TabletServerState.getStateById((byte)((Byte)badServer.getValue()));
                readableBadServers.addBadServer(new BadTabletServerInformation((String)badServer.getKey(), state.name()));
            }
            catch (IndexOutOfBoundsException e) {
                readableBadServers.addBadServer(new BadTabletServerInformation((String)badServer.getKey(), "Unknown state"));
            }
        }
        return readableBadServers;
    }

    public static ServersShuttingDown getServersShuttingDown(Monitor monitor) {
        ManagerMonitorInfo mmi = monitor.getMmi();
        ServersShuttingDown servers = new ServersShuttingDown();
        if (mmi == null) {
            return servers;
        }
        for (String server : mmi.serversShuttingDown) {
            servers.addServerShuttingDown(new ServerShuttingDownInformation(server));
        }
        return servers;
    }
}

