/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.tableExport;

import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.tableExport.ExportInfo;
import org.apache.accumulo.manager.tableOps.tableExport.WriteExportFiles;
import org.apache.hadoop.fs.Path;

public class ExportTable
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final ExportInfo tableInfo = new ExportInfo();
    public static final int VERSION = 1;
    public static final String DATA_VERSION_PROP = "srcDataVersion";
    public static final String EXPORT_VERSION_PROP = "exportVersion";

    public ExportTable(NamespaceId namespaceId, String tableName, TableId tableId, String exportDir) {
        this.tableInfo.tableName = tableName;
        this.tableInfo.exportDir = exportDir;
        this.tableInfo.tableID = tableId;
        this.tableInfo.namespaceID = namespaceId;
    }

    @Override
    public long isReady(long tid, Manager environment) throws Exception {
        return Utils.reserveHdfsDirectory(environment, new Path(this.tableInfo.exportDir).toString(), tid);
    }

    @Override
    public Repo<Manager> call(long tid, Manager env) {
        return new WriteExportFiles(this.tableInfo);
    }

    @Override
    public void undo(long tid, Manager env) throws Exception {
        Utils.unreserveHdfsDirectory(env, new Path(this.tableInfo.exportDir).toString(), tid);
    }
}

