/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.compactions.external;

import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.compactions.external.Compactors;
import org.apache.accumulo.monitor.rest.compactions.external.CoordinatorInfo;
import org.apache.accumulo.monitor.rest.compactions.external.ExternalCompactionInfo;
import org.apache.accumulo.monitor.rest.compactions.external.RunningCompactions;
import org.apache.accumulo.monitor.rest.compactions.external.RunningCompactorDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/ec")
@Produces(value={"application/json", "application/xml"})
public class ECResource {
    private static final Logger log = LoggerFactory.getLogger(ECResource.class);
    @Inject
    private Monitor monitor;

    @GET
    public CoordinatorInfo getCoordinator() {
        ExternalCompactionInfo cc = this.monitor.getCompactorsInfo();
        log.info("Got coordinator from monitor = {}", cc.getCoordinatorHost());
        return new CoordinatorInfo(cc.getCoordinatorHost(), cc);
    }

    @Path(value="compactors")
    @GET
    public Compactors getCompactors() {
        return new Compactors(this.monitor.getCompactorsInfo());
    }

    @Path(value="running")
    @GET
    public RunningCompactions getRunning() {
        return this.monitor.getRunningCompactions();
    }

    @Path(value="details")
    @GET
    public RunningCompactorDetails getDetails(@QueryParam(value="ecid") @NotNull String ecid) {
        RunningCompactorDetails runningCompactorDetails = this.monitor.getRunningCompactorDetails(ExternalCompactionId.from((String)(ecid = ExternalCompactionId.from((String)ecid).canonical())));
        if (runningCompactorDetails == null) {
            throw new IllegalStateException("Failed to find details for ECID: " + ecid);
        }
        return runningCompactorDetails;
    }
}

