/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.FinishCreateNamespace;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.NamespaceInfo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.util.NamespacePropUtil;

class PopulateZookeeperWithNamespace
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private NamespaceInfo namespaceInfo;

    PopulateZookeeperWithNamespace(NamespaceInfo ti) {
        this.namespaceInfo = ti;
    }

    @Override
    public long isReady(long id, Master environment) throws Exception {
        return Utils.reserveNamespace(this.namespaceInfo.namespaceId, id, true, false, TableOperation.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Utils.tableNameLock.lock();
        try {
            Instance instance = master.getInstance();
            Utils.checkNamespaceDoesNotExist(instance, this.namespaceInfo.namespaceName, this.namespaceInfo.namespaceId, TableOperation.CREATE);
            TableManager.prepareNewNamespaceState((String)instance.getInstanceID(), (String)this.namespaceInfo.namespaceId, (String)this.namespaceInfo.namespaceName, (ZooUtil.NodeExistsPolicy)ZooUtil.NodeExistsPolicy.OVERWRITE);
            for (Map.Entry<String, String> entry : this.namespaceInfo.props.entrySet()) {
                NamespacePropUtil.setNamespaceProperty((String)this.namespaceInfo.namespaceId, (String)entry.getKey(), (String)entry.getValue());
            }
            Tables.clearCache((Instance)instance);
            FinishCreateNamespace finishCreateNamespace = new FinishCreateNamespace(this.namespaceInfo);
            return finishCreateNamespace;
        }
        finally {
            Utils.tableNameLock.unlock();
        }
    }

    @Override
    public void undo(long tid, Master master) throws Exception {
        TableManager.getInstance().removeNamespace(this.namespaceInfo.namespaceId);
        Tables.clearCache((Instance)master.getInstance());
        Utils.unreserveNamespace(this.namespaceInfo.namespaceId, tid, true);
    }
}

