/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.mock;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import jline.console.ConsoleReader;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellOptionsJC;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.vfs2.FileSystemException;

@Deprecated
public class MockShell
extends Shell {
    private static final String NEWLINE = "\n";
    protected InputStream in;
    protected OutputStream out;

    public MockShell(InputStream in, OutputStream out) throws IOException {
        this.in = in;
        this.out = out;
    }

    @Override
    public boolean config(String ... args) throws IOException {
        if (!super.config(args)) {
            return false;
        }
        try {
            this.reader = new ConsoleReader(this.in, this.out);
        }
        catch (Exception e) {
            this.printException(e);
            return false;
        }
        this.reader.setHistoryEnabled(false);
        this.reader.setPaginationEnabled(false);
        this.verbose = false;
        return true;
    }

    @Override
    protected void setInstance(ShellOptionsJC options) {
        this.instance = new MockInstance();
    }

    @Override
    public int start() throws IOException {
        if (this.isVerbose()) {
            this.printInfo();
        }
        if (this.execFile != null) {
            try (Scanner scanner = new Scanner(this.execFile, StandardCharsets.UTF_8.name());){
                while (scanner.hasNextLine() && !this.hasExited()) {
                    this.execCommand(scanner.nextLine(), true, this.isVerbose());
                }
            }
        } else if (this.execCommand != null) {
            for (String command : this.execCommand.split(NEWLINE)) {
                this.execCommand(command, true, this.isVerbose());
            }
            return this.exitCode;
        }
        while (!this.hasExited()) {
            this.reader.setPrompt(this.getDefaultPrompt());
            String input = this.reader.readLine();
            if (input == null) {
                this.reader.println();
                return this.exitCode;
            }
            this.execCommand(input, false, false);
        }
        return this.exitCode;
    }

    public void setConsoleInputStream(InputStream in) {
        this.in = in;
    }

    public void setConsoleWriter(OutputStream out) {
        this.out = out;
    }

    @Override
    public ClassLoader getClassLoader(CommandLine cl, Shell shellState) throws AccumuloException, TableNotFoundException, AccumuloSecurityException, IOException, FileSystemException {
        return MockShell.class.getClassLoader();
    }

    public static ByteArrayInputStream makeCommands(String ... commands) {
        StringBuilder sb = new StringBuilder(commands.length * 8);
        for (String command : commands) {
            sb.append(command).append(NEWLINE);
        }
        return new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
    }
}

