/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.format;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.core.util.format.FormatterConfig;
import org.apache.accumulo.shell.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleterFormatter
extends DefaultFormatter {
    private static final Logger log = LoggerFactory.getLogger(DeleterFormatter.class);
    private BatchWriter writer;
    private Shell shellState;
    private boolean force;
    private boolean more;

    public DeleterFormatter(BatchWriter writer, Iterable<Map.Entry<Key, Value>> scanner, FormatterConfig config, Shell shellState, boolean force) {
        super.initialize(scanner, config);
        this.writer = writer;
        this.shellState = shellState;
        this.force = force;
        this.more = true;
    }

    public boolean hasNext() {
        if (!this.getScannerIterator().hasNext() || !this.more) {
            block4: {
                try {
                    this.writer.close();
                }
                catch (MutationsRejectedException e) {
                    log.error(e.toString());
                    if (!Shell.isDebuggingEnabled()) break block4;
                    for (ConstraintViolationSummary cvs : e.getConstraintViolationSummaries()) {
                        log.trace(cvs.toString());
                    }
                }
            }
            return false;
        }
        return true;
    }

    public String next() {
        Map.Entry next = (Map.Entry)this.getScannerIterator().next();
        Key key = (Key)next.getKey();
        Mutation m = new Mutation(key.getRow());
        String entryStr = DeleterFormatter.formatEntry((Map.Entry)next, (boolean)this.isDoTimestamps());
        boolean delete = this.force;
        try {
            block7: {
                if (!this.force) {
                    this.shellState.getReader().flush();
                    String line = this.shellState.getReader().readLine("Delete { " + entryStr + " } ? ");
                    this.more = line != null;
                    boolean bl = delete = line != null && (line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes"));
                }
                if (delete) {
                    m.putDelete(key.getColumnFamily(), key.getColumnQualifier(), new ColumnVisibility(key.getColumnVisibility()), key.getTimestamp());
                    try {
                        this.writer.addMutation(m);
                    }
                    catch (MutationsRejectedException e) {
                        log.error(e.toString());
                        if (!Shell.isDebuggingEnabled()) break block7;
                        for (ConstraintViolationSummary cvs : e.getConstraintViolationSummaries()) {
                            log.trace(cvs.toString());
                        }
                    }
                }
            }
            this.shellState.getReader().print((CharSequence)String.format("[%s] %s%n", delete ? "DELETED" : "SKIPPED", entryStr));
        }
        catch (IOException e) {
            log.error("Cannot write to console", (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }
}

