/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellCommandException;
import org.apache.accumulo.shell.Token;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class HelpCommand
extends Shell.Command {
    private Option disablePaginationOpt;
    private Option noWrapOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws ShellCommandException, IOException {
        int numColumns = shellState.getReader().getTerminal().getWidth();
        if (cl.hasOption(this.noWrapOpt.getOpt())) {
            numColumns = Integer.MAX_VALUE;
        }
        if (cl.getArgs().length == 0) {
            int i = 0;
            for (String cmd : shellState.commandFactory.keySet()) {
                i = Math.max(i, cmd.length());
            }
            if (numColumns < 40) {
                throw new IllegalArgumentException("numColumns must be at least 40 (was " + numColumns + ")");
            }
            ArrayList<String> output = new ArrayList<String>();
            for (Map.Entry<String, Shell.Command[]> cmdGroup : shellState.commandGrouping.entrySet()) {
                output.add(cmdGroup.getKey());
                for (Shell.Command c : cmdGroup.getValue()) {
                    int beginIndex;
                    String n = c.getName();
                    String s = c.description();
                    if (s == null) {
                        s = "";
                    }
                    int endIndex = s.length();
                    for (beginIndex = 0; beginIndex < endIndex && s.charAt(beginIndex) == ' '; ++beginIndex) {
                    }
                    String dash = "-";
                    while (endIndex > beginIndex && endIndex - beginIndex + i + 5 > numColumns) {
                        endIndex = s.lastIndexOf(" ", numColumns + beginIndex - i - 5);
                        if (endIndex == -1 || endIndex < beginIndex) {
                            endIndex = numColumns + beginIndex - i - 5 - 1;
                            output.add(String.format("%-" + i + "s  %s  %s-", n, dash, s.substring(beginIndex, endIndex)));
                            dash = " ";
                            beginIndex = endIndex;
                        } else {
                            output.add(String.format("%-" + i + "s  %s  %s", n, dash, s.substring(beginIndex, endIndex)));
                            dash = " ";
                            beginIndex = endIndex + 1;
                        }
                        n = "";
                        endIndex = s.length();
                        while (beginIndex < endIndex && s.charAt(beginIndex) == ' ') {
                            ++beginIndex;
                        }
                    }
                    output.add(String.format("%-" + i + "s  %s  %s", n, dash, s.substring(beginIndex, endIndex)));
                }
                output.add("");
            }
            shellState.printLines(output.iterator(), !cl.hasOption(this.disablePaginationOpt.getOpt()));
        }
        for (String cmd : cl.getArgs()) {
            Shell.Command c = shellState.commandFactory.get(cmd);
            if (c == null) {
                shellState.getReader().println((CharSequence)String.format("Unknown command \"%s\".  Enter \"help\" for a list possible commands.", cmd));
                continue;
            }
            c.printHelp(shellState, numColumns);
        }
        return 0;
    }

    @Override
    public String description() {
        return "provides information about the available commands";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> special) {
        this.registerCompletionForCommands(root, special);
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disable pagination of output");
        o.addOption(this.disablePaginationOpt);
        this.noWrapOpt = new Option("nw", "no-wrap", false, "disable wrapping of output");
        o.addOption(this.noWrapOpt);
        return o;
    }

    @Override
    public String usage() {
        return this.getName() + " [ <command>{ <command>} ]";
    }

    @Override
    public int numArgs() {
        return -1;
    }
}

