/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class GetSplitsCommand
extends Shell.Command {
    private Option outputFileOpt;
    private Option maxSplitsOpt;
    private Option base64Opt;
    private Option verboseOpt;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        String outputFile = cl.getOptionValue(this.outputFileOpt.getOpt());
        String m = cl.getOptionValue(this.maxSplitsOpt.getOpt());
        int maxSplits = m == null ? 0 : Integer.parseInt(m);
        boolean encode = cl.hasOption(this.base64Opt.getOpt());
        boolean verbose = cl.hasOption(this.verboseOpt.getOpt());
        try (Shell.PrintLine p = outputFile == null ? new Shell.PrintShell(shellState.getReader()) : new Shell.PrintFile(outputFile);){
            if (!verbose) {
                for (Text row : maxSplits > 0 ? shellState.getConnector().tableOperations().listSplits(tableName, maxSplits) : shellState.getConnector().tableOperations().listSplits(tableName)) {
                    p.print(GetSplitsCommand.encode(encode, row));
                }
            } else {
                String systemTableToCheck = "accumulo.metadata".equals(tableName) ? "accumulo.root" : "accumulo.metadata";
                Scanner scanner = shellState.getConnector().createScanner(systemTableToCheck, Authorizations.EMPTY);
                MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
                Text start = new Text((String)shellState.getConnector().tableOperations().tableIdMap().get(tableName));
                Text end = new Text(start);
                start.append(new byte[]{59}, 0, 1);
                end.append(new byte[]{60}, 0, 1);
                scanner.setRange(new Range(start, end));
                for (Map.Entry next : scanner) {
                    if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns((Key)next.getKey())) continue;
                    KeyExtent extent = new KeyExtent(((Key)next.getKey()).getRow(), (Value)next.getValue());
                    String pr = GetSplitsCommand.encode(encode, extent.getPrevEndRow());
                    String er = GetSplitsCommand.encode(encode, extent.getEndRow());
                    String line = String.format("%-26s (%s, %s%s", GetSplitsCommand.obscuredTabletName(extent), pr == null ? "-inf" : pr, er == null ? "+inf" : er, er == null ? ") Default Tablet " : "]");
                    p.print(line);
                }
            }
        }
        return 0;
    }

    private static String encode(boolean encode, Text text) {
        if (text == null) {
            return null;
        }
        int length = text.getLength();
        return encode ? Base64.getEncoder().encodeToString(TextUtil.getBytes((Text)text)) : DefaultFormatter.appendText((StringBuilder)new StringBuilder(), (Text)text, (int)length).toString();
    }

    private static String obscuredTabletName(KeyExtent extent) {
        MessageDigest digester;
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (extent.getEndRow() != null && extent.getEndRow().getLength() > 0) {
            digester.update(extent.getEndRow().getBytes(), 0, extent.getEndRow().getLength());
        }
        return Base64.getEncoder().encodeToString(digester.digest());
    }

    @Override
    public String description() {
        return "retrieves the current split points for tablets in the current table";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options opts = new Options();
        this.outputFileOpt = new Option("o", "output", true, "local file to write the splits to");
        this.outputFileOpt.setArgName("file");
        this.maxSplitsOpt = new Option("m", "max", true, "maximum number of splits to return (evenly spaced)");
        this.maxSplitsOpt.setArgName("num");
        this.base64Opt = new Option("b64", "base64encoded", false, "encode the split points");
        this.verboseOpt = new Option("v", "verbose", false, "print out the tablet information with start/end rows");
        opts.addOption(this.outputFileOpt);
        opts.addOption(this.maxSplitsOpt);
        opts.addOption(this.base64Opt);
        opts.addOption(this.verboseOpt);
        opts.addOption(OptUtil.tableOpt("table to get splits for"));
        return opts;
    }
}

