/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.AdminUtil;
import org.apache.accumulo.fate.ReadOnlyRepo;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.ZooStore;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.zookeeper.KeeperException;

public class FateCommand
extends Shell.Command {
    private static final String SCHEME = "digest";
    private static final String USER = "accumulo";
    private Option secretOption;
    private Option statusOption;
    private Option disablePaginationOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws ParseException, KeeperException, InterruptedException, IOException {
        Instance instance = shellState.getInstance();
        String[] args = cl.getArgs();
        if (args.length <= 0) {
            throw new ParseException("Must provide a command to execute");
        }
        String cmd = args[0];
        boolean failedCommand = false;
        AdminUtil admin = new AdminUtil(false);
        String path = ZooUtil.getRoot((Instance)instance) + "/fate";
        String masterPath = ZooUtil.getRoot((Instance)instance) + "/masters/lock";
        IZooReaderWriter zk = this.getZooReaderWriter(shellState.getInstance(), cl.getOptionValue(this.secretOption.getOpt()));
        ZooStore zs = new ZooStore(path, zk);
        if ("fail".equals(cmd)) {
            if (args.length <= 1) {
                throw new ParseException("Must provide transaction ID");
            }
            for (int i = 1; i < args.length; ++i) {
                if (admin.prepFail((TStore)zs, zk, masterPath, args[i])) continue;
                System.out.printf("Could not fail transaction: %s%n", args[i]);
                failedCommand = true;
            }
        } else if ("delete".equals(cmd)) {
            if (args.length <= 1) {
                throw new ParseException("Must provide transaction ID");
            }
            for (int i = 1; i < args.length; ++i) {
                if (admin.prepDelete((TStore)zs, zk, masterPath, args[i])) {
                    admin.deleteLocks((TStore)zs, zk, ZooUtil.getRoot((Instance)instance) + "/table_locks", args[i]);
                    continue;
                }
                System.out.printf("Could not delete transaction: %s%n", args[i]);
                failedCommand = true;
            }
        } else if ("list".equals(cmd) || "print".equals(cmd)) {
            HashSet<Long> filterTxid = null;
            if (args.length >= 2) {
                filterTxid = new HashSet<Long>(args.length);
                for (int i = 1; i < args.length; ++i) {
                    try {
                        Long val = Long.parseLong(args[i], 16);
                        filterTxid.add(val);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.out.printf("Invalid transaction ID format: %s%n", args[i]);
                        return 1;
                    }
                }
            }
            EnumSet<ReadOnlyTStore.TStatus> filterStatus = null;
            if (cl.hasOption(this.statusOption.getOpt())) {
                filterStatus = EnumSet.noneOf(ReadOnlyTStore.TStatus.class);
                String[] tstat = cl.getOptionValues(this.statusOption.getOpt());
                for (int i = 0; i < tstat.length; ++i) {
                    try {
                        filterStatus.add(ReadOnlyTStore.TStatus.valueOf((String)tstat[i]));
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        System.out.printf("Invalid transaction status name: %s%n", tstat[i]);
                        return 1;
                    }
                }
            }
            StringBuilder buf = new StringBuilder(8096);
            Formatter fmt = new Formatter(buf);
            admin.print((ReadOnlyTStore)zs, (IZooReader)zk, ZooUtil.getRoot((Instance)instance) + "/table_locks", fmt, filterTxid, filterStatus);
            shellState.printLines(Collections.singletonList(buf.toString()).iterator(), !cl.hasOption(this.disablePaginationOpt.getOpt()));
        } else if ("dump".equals(cmd)) {
            ArrayList<Long> txids;
            if (args.length == 1) {
                txids = zs.list();
            } else {
                txids = new ArrayList<Long>();
                for (int i = 1; i < args.length; ++i) {
                    txids.add(Long.parseLong(args[i], 16));
                }
            }
            Gson gson = new GsonBuilder().registerTypeAdapter(ReadOnlyRepo.class, new InterfaceSerializer()).registerTypeAdapter(Repo.class, new InterfaceSerializer()).registerTypeAdapter(byte[].class, (Object)new ByteArraySerializer()).setPrettyPrinting().create();
            ArrayList<FateStack> txStacks = new ArrayList<FateStack>();
            for (Long txid : txids) {
                List repoStack = zs.getStack(txid.longValue());
                txStacks.add(new FateStack(txid, repoStack));
            }
            System.out.println(gson.toJson(txStacks));
        } else {
            throw new ParseException("Invalid command option");
        }
        return failedCommand ? 1 : 0;
    }

    protected synchronized IZooReaderWriter getZooReaderWriter(Instance instance, String secret) {
        if (secret == null) {
            SiteConfiguration conf = SiteConfiguration.getInstance();
            secret = conf.get(Property.INSTANCE_SECRET);
        }
        return new ZooReaderWriter(instance.getZooKeepers(), instance.getZooKeepersSessionTimeOut(), SCHEME, ("accumulo:" + secret).getBytes());
    }

    @Override
    public String description() {
        return "manage FATE transactions";
    }

    @Override
    public String usage() {
        return this.getName() + " fail <txid>... | delete <txid>... | print [<txid>...] | dump [<txid>...]";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.secretOption = new Option("s", "secret", true, "specify the instance secret to use");
        this.secretOption.setOptionalArg(false);
        o.addOption(this.secretOption);
        this.statusOption = new Option("t", "status-type", true, "filter 'print' on the transaction status type(s) {NEW, IN_PROGRESS, FAILED_IN_PROGRESS, FAILED, SUCCESSFUL}");
        this.statusOption.setArgs(-2);
        this.statusOption.setOptionalArg(false);
        o.addOption(this.statusOption);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disables pagination of output");
        o.addOption(this.disablePaginationOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return -1;
    }

    public static class FateStack {
        String txid;
        List<ReadOnlyRepo<FateCommand>> stack;

        FateStack(Long txid, List<ReadOnlyRepo<FateCommand>> stack) {
            this.txid = String.format("%016x", txid);
            this.stack = stack;
        }
    }

    private static class ByteArraySerializer
    implements JsonSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        public JsonElement serialize(byte[] link, Type type, JsonSerializationContext context) {
            return context.serialize((Object)new ByteArrayContainer(link));
        }
    }

    public static class ByteArrayContainer {
        public String asUtf8;
        public String asBase64;

        ByteArrayContainer(byte[] ba) {
            this.asUtf8 = new String(ba, StandardCharsets.UTF_8);
            this.asBase64 = Base64.getUrlEncoder().encodeToString(ba);
        }
    }

    private static class InterfaceSerializer<T>
    implements JsonSerializer<T> {
        private InterfaceSerializer() {
        }

        public JsonElement serialize(T link, Type type, JsonSerializationContext context) {
            JsonElement je = context.serialize(link, link.getClass());
            JsonObject jo = new JsonObject();
            jo.add(link.getClass().getName(), je);
            return jo;
        }
    }
}

