/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.concurrent;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;

public class BatchWrite
extends Test {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Connector conn = env.getConnector();
        Random rand = (Random)state.get("rand");
        List tableNames = (List)state.get("tables");
        String tableName = (String)tableNames.get(rand.nextInt(tableNames.size()));
        try {
            try (BatchWriter bw = conn.createBatchWriter(tableName, new BatchWriterConfig());){
                int numRows = rand.nextInt(100000);
                for (int i = 0; i < numRows; ++i) {
                    Mutation m = new Mutation((CharSequence)String.format("%016x", rand.nextLong() & Long.MAX_VALUE));
                    long val = rand.nextLong() & Long.MAX_VALUE;
                    for (int j = 0; j < 10; ++j) {
                        m.put((CharSequence)"cf", (CharSequence)("cq" + j), new Value(String.format("%016x", val).getBytes(StandardCharsets.UTF_8)));
                    }
                    bw.addMutation(m);
                }
            }
            this.log.debug((Object)("Wrote to " + tableName));
        }
        catch (TableNotFoundException e) {
            this.log.debug((Object)("BatchWrite " + tableName + " failed, doesnt exist"));
        }
        catch (TableOfflineException e) {
            this.log.debug((Object)("BatchWrite " + tableName + " failed, offline"));
        }
        catch (MutationsRejectedException mre) {
            if (mre.getCause() instanceof TableDeletedException) {
                this.log.debug((Object)("BatchWrite " + tableName + " failed, table deleted"));
            }
            if (mre.getCause() instanceof TableOfflineException) {
                this.log.debug((Object)("BatchWrite " + tableName + " failed, offline"));
            }
            throw mre;
        }
    }
}

