/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.io.FileNotFoundException;
import java.util.Iterator;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiniClusterOnlyTests.class})
public class TableIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void test() throws Exception {
        Assume.assumeTrue((TableIT.getClusterType() == AccumuloClusterHarness.ClusterType.MINI ? 1 : 0) != 0);
        AccumuloCluster cluster = TableIT.getCluster();
        MiniAccumuloClusterImpl mac = (MiniAccumuloClusterImpl)cluster;
        String rootPath = mac.getConfig().getDir().getAbsolutePath();
        Connector c = this.getConnector();
        TableOperations to = c.tableOperations();
        String tableName = this.getUniqueNames(1)[0];
        to.create(tableName);
        TestIngest.Opts opts = new TestIngest.Opts();
        VerifyIngest.Opts vopts = new VerifyIngest.Opts();
        ClientConfiguration clientConfig = TableIT.getCluster().getClientConfig();
        if (clientConfig.hasSasl()) {
            opts.updateKerberosCredentials(clientConfig);
            vopts.updateKerberosCredentials(clientConfig);
        } else {
            opts.setPrincipal(TableIT.getAdminPrincipal());
            vopts.setPrincipal(TableIT.getAdminPrincipal());
        }
        opts.setTableName(tableName);
        TestIngest.ingest(c, opts, new BatchWriterOpts());
        to.flush(tableName, null, null, true);
        vopts.setTableName(tableName);
        VerifyIngest.verifyIngest(c, vopts, new ScannerOpts());
        String id = (String)to.tableIdMap().get(tableName);
        Scanner s = c.createScanner("accumulo.metadata", Authorizations.EMPTY);
        s.setRange(new KeyExtent(id, null, null).toMetadataRange());
        s.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        Assert.assertTrue((Iterators.size((Iterator)s.iterator()) > 0 ? 1 : 0) != 0);
        FileSystem fs = TableIT.getCluster().getFileSystem();
        Assert.assertTrue((fs.listStatus(new Path(rootPath + "/accumulo/tables/" + id)).length > 0 ? 1 : 0) != 0);
        to.delete(tableName);
        Assert.assertEquals((long)0L, (long)Iterators.size((Iterator)s.iterator()));
        try {
            Assert.assertEquals((long)0L, (long)fs.listStatus(new Path(rootPath + "/accumulo/tables/" + id)).length);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        Assert.assertNull(to.tableIdMap().get(tableName));
        to.create(tableName);
        TestIngest.ingest(c, opts, new BatchWriterOpts());
        VerifyIngest.verifyIngest(c, vopts, new ScannerOpts());
        to.delete(tableName);
    }
}

