/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.Map;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.file.rfile.CreateEmpty;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.ReadWriteIT;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryWithEmptyRFileIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(RecoveryWithEmptyRFileIT.class);
    static final int ROWS = 200000;
    static final int COLS = 1;
    static final String COLF = "colf";

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.useMiniDFS(true);
    }

    @Test
    public void replaceMissingRFile() throws Exception {
        log.info("Ingest some data, verify it was stored properly, replace an underlying rfile with an empty one and verify we can scan.");
        Connector connector = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        ReadWriteIT.ingest(connector, this.cluster.getClientConfig(), "root", 200000, 1, 50, 0, tableName);
        ReadWriteIT.verify(connector, this.cluster.getClientConfig(), "root", 200000, 1, 50, 0, tableName);
        connector.tableOperations().flush(tableName, null, null, true);
        connector.tableOperations().offline(tableName, true);
        log.debug("Replacing rfile(s) with empty");
        Scanner meta = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
        String tableId = (String)connector.tableOperations().tableIdMap().get(tableName);
        meta.setRange(new Range(new Text(tableId + ";"), new Text(tableId + "<")));
        meta.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
        boolean foundFile = false;
        for (Map.Entry entry : meta) {
            foundFile = true;
            Path rfile = new Path(((Key)entry.getKey()).getColumnQualifier().toString());
            log.debug("Removing rfile '" + rfile + "'");
            this.cluster.getFileSystem().delete(rfile, false);
            Process info = this.cluster.exec(CreateEmpty.class, new String[]{rfile.toString()});
            Assert.assertEquals((long)0L, (long)info.waitFor());
        }
        meta.close();
        Assert.assertTrue((boolean)foundFile);
        log.trace("invalidate cached file handles by issuing a compaction");
        connector.tableOperations().online(tableName, true);
        connector.tableOperations().compact(tableName, null, null, false, true);
        log.debug("make sure we can still scan");
        Scanner scan = connector.createScanner(tableName, Authorizations.EMPTY);
        scan.setRange(new Range());
        long cells = 0L;
        for (Map.Entry entry : scan) {
            if (entry == null) continue;
            ++cells;
        }
        scan.close();
        Assert.assertEquals((long)0L, (long)cells);
    }
}

