/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.metrics.MetricsFileTailer;
import org.apache.accumulo.test.util.SlowOps;
import org.apache.hadoop.conf.Configuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterMetricsIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(MasterMetricsIT.class);
    private static final int NUM_TAIL_ATTEMPTS = 20;
    private static final long TAIL_DELAY = 5000L;
    private final int tableCount = 4;
    private long maxWait;
    private static final Set<String> REQUIRED_METRIC_KEYS = new HashSet<String>(Arrays.asList("currentFateOps", "totalFateOps", "totalZkConnErrors", "FateTxState_NEW", "FateTxState_IN_PROGRESS", "FateTxState_FAILED_IN_PROGRESS", "FateTxState_FAILED", "FateTxState_SUCCESSFUL", "FateTxState_UNKNOWN"));
    private static final Set<String> OPTIONAL_METRIC_KEYS = new HashSet<String>(Collections.singletonList("FateTxOpType_CompactRange"));
    private final MetricsFileTailer metricsTail = new MetricsFileTailer("accumulo.sink.file-master");

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.GENERAL_LEGACY_METRICS, "false");
        cfg.setProperty(Property.MASTER_FATE_METRICS_ENABLED, "true");
        cfg.setProperty(Property.MASTER_FATE_METRICS_MIN_UPDATE_INTERVAL, "5s");
    }

    @Before
    public void setup() {
        if (this.testDisabled()) {
            return;
        }
        this.maxWait = this.defaultTimeoutSeconds() <= 0 ? 60000L : (long)(this.defaultTimeoutSeconds() * 1000 / 2);
        this.metricsTail.startDaemonThread();
    }

    @After
    public void cleanup() {
        this.metricsTail.close();
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void metricsPublished() {
        if (this.testDisabled()) {
            log.info("Skipping test - master metrics not enabled.");
            return;
        }
        MetricsFileTailer.LineUpdate firstUpdate = this.metricsTail.waitForUpdate(-1L, 20, 5000L);
        firstUpdate = this.metricsTail.waitForUpdate(firstUpdate.getLastUpdate(), 20, 5000L);
        Map<String, Long> firstSeenMap = this.parseLine(firstUpdate.getLine());
        log.debug("Line received: {}", (Object)firstUpdate.getLine());
        log.info("Expected metrics count: {}", (Object)REQUIRED_METRIC_KEYS.size());
        log.info("Received metrics count: {},  values:{}", (Object)firstSeenMap.size(), firstSeenMap);
        Assert.assertTrue((boolean)this.lookForExpectedKeys(firstSeenMap));
        this.sanity(firstSeenMap);
        MetricsFileTailer.LineUpdate nextUpdate = this.metricsTail.waitForUpdate(firstUpdate.getLastUpdate(), 20, 5000L);
        Map<String, Long> updateSeenMap = this.parseLine(nextUpdate.getLine());
        log.debug("Line received:{}", (Object)nextUpdate.getLine());
        log.trace("Mapped values:{}", updateSeenMap);
        Assert.assertTrue((boolean)this.lookForExpectedKeys(updateSeenMap));
        this.sanity(updateSeenMap);
        this.validate(firstSeenMap, updateSeenMap);
    }

    @Test
    public void compactionMetrics() {
        if (this.testDisabled()) {
            log.info("Skipping test - MASTER_FATE_METRICS_ENABLED is not enabled");
            return;
        }
        MetricsFileTailer.LineUpdate firstUpdate = this.metricsTail.waitForUpdate(-1L, 20, 5000L);
        ArrayList<SlowOps> tables = new ArrayList<SlowOps>();
        for (int i = 0; i < 4; ++i) {
            String uniqueName = this.getUniqueNames(1)[0] + "_" + i;
            Iterator gen = new SlowOps(this.getConnector(), uniqueName, this.maxWait, 4);
            tables.add((SlowOps)((Object)gen));
            ((SlowOps)((Object)gen)).startCompactTask();
        }
        MetricsFileTailer.LineUpdate nextUpdate = this.metricsTail.waitForUpdate(firstUpdate.getLastUpdate(), 20, 5000L);
        log.info("Received metrics {}", (Object)nextUpdate);
        Map<String, String> results = this.blockForRequiredTables();
        Assert.assertFalse((boolean)results.isEmpty());
        log.info("IN_PROGRESS: {}", (Object)results.get("FateTxState_IN_PROGRESS"));
        Assert.assertTrue((Long.parseLong(results.get("FateTxState_IN_PROGRESS")) >= 4L ? 1 : 0) != 0);
        Assert.assertTrue((Long.parseLong(results.get("FateTxOpType_CompactRange")) >= 4L ? 1 : 0) != 0);
        for (String k : OPTIONAL_METRIC_KEYS) {
            Assert.assertTrue((boolean)results.containsKey(k));
            Assert.assertTrue((Long.parseLong(results.get(k)) >= 4L ? 1 : 0) != 0);
        }
        for (SlowOps t : tables) {
            try {
                this.getConnector().tableOperations().cancelCompaction(t.getTableName());
                boolean cancelled = t.blockWhileCompactionRunning();
                if (cancelled) continue;
                log.info("Failed to cancel compaction during multiple compaction test clean-up for {}", (Object)t.getTableName());
            }
            catch (AccumuloException | AccumuloSecurityException | TableNotFoundException ex) {
                log.debug("Exception thrown during multiple table test clean-up", ex);
            }
        }
        for (SlowOps t : tables) {
            try {
                log.debug("delete table {}", (Object)t.getTableName());
                this.getConnector().tableOperations().delete(t.getTableName());
            }
            catch (AccumuloException | AccumuloSecurityException | TableNotFoundException throwable) {}
        }
        MetricsFileTailer.LineUpdate update = this.metricsTail.waitForUpdate(0L, 20, 5000L);
        this.metricsTail.waitForUpdate(update.getLastUpdate(), 20, 5000L);
        results = this.metricsTail.parseLine("");
        log.info("Received metrics {}", results);
    }

    private Map<String, String> blockForRequiredTables() {
        MetricsFileTailer.LineUpdate update = this.metricsTail.waitForUpdate(0L, 20, 5000L);
        for (int i = 0; i < 20; ++i) {
            update = this.metricsTail.waitForUpdate(update.getLastUpdate(), 20, 5000L);
            log.info("Received metrics update {}", (Object)update);
            Map<String, String> results = this.metricsTail.parseLine("");
            if (results != null && results.size() > 0 && Long.parseLong(results.get("currentFateOps")) >= 4L) {
                log.info("Found required number of fate operations");
                return results;
            }
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
                return Collections.emptyMap();
            }
        }
        return Collections.emptyMap();
    }

    private void sanity(Map<String, Long> values) {
        Assert.assertTrue((values.get("currentFateOps") <= values.get("totalFateOps") ? 1 : 0) != 0);
        long total = values.entrySet().stream().filter(x -> ((String)x.getKey()).startsWith("FateTxState_")).mapToLong(Map.Entry::getValue).sum();
        Assert.assertTrue((total >= values.get("currentFateOps") ? 1 : 0) != 0);
    }

    private void validate(Map<String, Long> firstSeen, Map<String, Long> nextSeen) {
        log.debug("Total fate ops.  Before:{}, Update:{}", (Object)firstSeen.get("totalFateOps"), (Object)nextSeen.get("totalFateOps"));
        Assert.assertTrue((firstSeen.get("totalFateOps") <= nextSeen.get("totalFateOps") ? 1 : 0) != 0);
    }

    private Map<String, Long> parseLine(String line) {
        String[] csvTokens;
        if (line == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, Long> m = new TreeMap<String, Long>();
        for (String token : csvTokens = line.split(",")) {
            String[] parts = (token = token.trim()).split("=");
            if (!REQUIRED_METRIC_KEYS.contains(parts[0])) continue;
            m.put(parts[0], Long.parseLong(parts[1]));
        }
        return m;
    }

    private boolean lookForExpectedKeys(Map<String, Long> received) {
        for (String e : REQUIRED_METRIC_KEYS) {
            if (received.containsKey(e)) continue;
            log.info("Couldn't find {}", (Object)e);
            return false;
        }
        return true;
    }

    private boolean testDisabled() {
        boolean fateMetricsEnabled = cluster.getSiteConfiguration().getBoolean(Property.MASTER_FATE_METRICS_ENABLED);
        boolean useLegacyMetrics = cluster.getSiteConfiguration().getBoolean(Property.GENERAL_LEGACY_METRICS);
        if (!fateMetricsEnabled || useLegacyMetrics) {
            log.info("master fate metrics are disabled - MASTER_FATE_METRICS_ENABLED={}, GENERAL_LEGACY_METRICS={}", (Object)fateMetricsEnabled, (Object)useLegacyMetrics);
            return true;
        }
        return false;
    }
}

