/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.util.TreeSet;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.TestBinaryRows;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class BinaryIT
extends AccumuloClusterHarness {
    @Override
    protected int defaultTimeoutSeconds() {
        return 90;
    }

    @Test
    public void test() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        BinaryIT.runTest(c, tableName);
    }

    @Test
    public void testPreSplit() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(tableName);
        TreeSet<Text> splits = new TreeSet<Text>();
        splits.add(new Text("8"));
        splits.add(new Text("256"));
        c.tableOperations().addSplits(tableName, splits);
        BinaryIT.runTest(c, tableName);
    }

    public static void runTest(Connector c, String tableName) throws Exception {
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        ScannerOpts scanOpts = new ScannerOpts();
        TestBinaryRows.Opts opts = new TestBinaryRows.Opts();
        opts.setTableName(tableName);
        opts.start = 0L;
        opts.num = 100000L;
        opts.mode = "ingest";
        TestBinaryRows.runTest(c, opts, bwOpts, scanOpts);
        opts.mode = "verify";
        TestBinaryRows.runTest(c, opts, bwOpts, scanOpts);
        opts.start = 25000L;
        opts.num = 50000L;
        opts.mode = "delete";
        TestBinaryRows.runTest(c, opts, bwOpts, scanOpts);
        opts.start = 0L;
        opts.num = 25000L;
        opts.mode = "verify";
        TestBinaryRows.runTest(c, opts, bwOpts, scanOpts);
        opts.start = 75000L;
        opts.num = 25000L;
        opts.mode = "randomLookups";
        TestBinaryRows.runTest(c, opts, bwOpts, scanOpts);
        opts.start = 25000L;
        opts.num = 50000L;
        opts.mode = "verifyDeleted";
        TestBinaryRows.runTest(c, opts, bwOpts, scanOpts);
    }
}

