/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.test.continuous.BulkIngest;
import org.apache.accumulo.test.continuous.ContinuousIngest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ContinuousInputFormat
extends InputFormat<Key, Value> {
    private static final String PROP_UUID = "mrbulk.uuid";
    private static final String PROP_MAP_TASK = "mrbulk.map.task";
    private static final String PROP_MAP_NODES = "mrbulk.map.nodes";
    private static final String PROP_ROW_MIN = "mrbulk.row.min";
    private static final String PROP_ROW_MAX = "mrbulk.row.max";
    private static final String PROP_FAM_MAX = "mrbulk.fam.max";
    private static final String PROP_QUAL_MAX = "mrbulk.qual.max";
    private static final String PROP_CHECKSUM = "mrbulk.checksum";
    private static final String PROP_VIS_FILE = "mrbulk.vis.file";

    public List<InputSplit> getSplits(JobContext jobContext) {
        int numTask = jobContext.getConfiguration().getInt(PROP_MAP_TASK, 1);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (int i = 0; i < numTask; ++i) {
            splits.add(new RandomSplit());
        }
        return splits;
    }

    public static void configure(Configuration conf, String uuid, BulkIngest.Opts opts) {
        conf.set(PROP_UUID, uuid);
        conf.setInt(PROP_MAP_TASK, opts.mapTasks);
        conf.setLong(PROP_MAP_NODES, (long)opts.mapNodes);
        conf.setLong(PROP_ROW_MIN, opts.min);
        conf.setLong(PROP_ROW_MAX, opts.max);
        conf.setInt(PROP_FAM_MAX, (int)opts.maxColF);
        conf.setInt(PROP_QUAL_MAX, (int)opts.maxColQ);
        if (opts.visFile != null) {
            conf.set(PROP_VIS_FILE, opts.visFile);
        }
        conf.setBoolean(PROP_CHECKSUM, opts.checksum);
    }

    public RecordReader<Key, Value> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        return new RecordReader<Key, Value>(){
            long numNodes;
            long nodeCount;
            private Random random;
            private byte[] uuid;
            long minRow;
            long maxRow;
            int maxFam;
            int maxQual;
            List<ColumnVisibility> visibilities;
            boolean checksum;
            Key prevKey;
            Key currKey;
            Value currValue;

            public void initialize(InputSplit inputSplit, TaskAttemptContext job) {
                this.numNodes = job.getConfiguration().getLong(ContinuousInputFormat.PROP_MAP_NODES, 1000000L);
                this.uuid = job.getConfiguration().get(ContinuousInputFormat.PROP_UUID).getBytes(StandardCharsets.UTF_8);
                this.minRow = job.getConfiguration().getLong(ContinuousInputFormat.PROP_ROW_MIN, 0L);
                this.maxRow = job.getConfiguration().getLong(ContinuousInputFormat.PROP_ROW_MAX, Long.MAX_VALUE);
                this.maxFam = job.getConfiguration().getInt(ContinuousInputFormat.PROP_FAM_MAX, Short.MAX_VALUE);
                this.maxQual = job.getConfiguration().getInt(ContinuousInputFormat.PROP_QUAL_MAX, Short.MAX_VALUE);
                this.checksum = job.getConfiguration().getBoolean(ContinuousInputFormat.PROP_CHECKSUM, false);
                String visFile = job.getConfiguration().get(ContinuousInputFormat.PROP_VIS_FILE);
                this.visibilities = visFile == null ? Collections.singletonList(new ColumnVisibility()) : ContinuousIngest.readVisFromFile(visFile);
                this.random = new Random(new SecureRandom().nextLong());
                this.nodeCount = 0L;
            }

            private Key genKey(CRC32 cksum) {
                byte[] row = ContinuousIngest.genRow(ContinuousIngest.genLong(this.minRow, this.maxRow, this.random));
                byte[] fam = ContinuousIngest.genCol(this.random.nextInt(this.maxFam));
                byte[] qual = ContinuousIngest.genCol(this.random.nextInt(this.maxQual));
                byte[] cv = this.visibilities.get(this.random.nextInt(this.visibilities.size())).flatten();
                if (cksum != null) {
                    cksum.update(row);
                    cksum.update(fam);
                    cksum.update(qual);
                    cksum.update(cv);
                }
                return new Key(row, fam, qual, cv);
            }

            private byte[] createValue(byte[] ingestInstanceId, byte[] prevRow, Checksum cksum) {
                return ContinuousIngest.createValue(ingestInstanceId, this.nodeCount, prevRow, cksum);
            }

            public boolean nextKeyValue() {
                if (this.nodeCount < this.numNodes) {
                    CRC32 cksum = this.checksum ? new CRC32() : null;
                    this.prevKey = this.currKey;
                    byte[] prevRow = this.prevKey != null ? this.prevKey.getRowData().toArray() : null;
                    this.currKey = this.genKey(cksum);
                    this.currValue = new Value(this.createValue(this.uuid, prevRow, cksum));
                    ++this.nodeCount;
                    return true;
                }
                return false;
            }

            public Key getCurrentKey() {
                return this.currKey;
            }

            public Value getCurrentValue() {
                return this.currValue;
            }

            public float getProgress() {
                return (float)this.nodeCount * 1.0f / (float)this.numNodes;
            }

            public void close() throws IOException {
            }
        };
    }

    private static class RandomSplit
    extends InputSplit
    implements Writable {
        private RandomSplit() {
        }

        public void write(DataOutput dataOutput) {
        }

        public void readFields(DataInput dataInput) {
        }

        public long getLength() {
            return 0L;
        }

        public String[] getLocations() {
            return new String[0];
        }
    }
}

