/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.validators.PositiveInteger;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Base64;
import java.util.Collection;
import java.util.UUID;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.MapReduceClientOnDefaultTable;
import org.apache.accumulo.core.client.mapreduce.AccumuloFileOutputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.partition.KeyRangePartitioner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.continuous.ContinuousInputFormat;
import org.apache.accumulo.test.continuous.ContinuousOpts;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkIngest
extends Configured
implements Tool {
    public static final Logger log = LoggerFactory.getLogger(BulkIngest.class);

    public int run(String[] args) throws Exception {
        String ingestInstanceId = UUID.randomUUID().toString();
        Job job = Job.getInstance((Configuration)this.getConf());
        job.setJobName("BulkIngest_" + ingestInstanceId);
        job.setJarByClass(BulkIngest.class);
        job.getConfiguration().set("mapreduce.job.classloader", "true");
        FileSystem fs = FileSystem.get((Configuration)job.getConfiguration());
        log.info(String.format("UUID %d %s", System.currentTimeMillis(), ingestInstanceId));
        job.setInputFormatClass(ContinuousInputFormat.class);
        job.setMapOutputKeyClass(Key.class);
        job.setMapOutputValueClass(Value.class);
        Opts opts = new Opts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        MapReduceClientOnDefaultTable clientOpts = new MapReduceClientOnDefaultTable("ci");
        clientOpts.parseArgs(BulkIngest.class.getName(), args, new Object[]{bwOpts, opts});
        fs.mkdirs(new Path(opts.dir));
        job.setOutputFormatClass(AccumuloFileOutputFormat.class);
        AccumuloFileOutputFormat.setOutputPath((Job)job, (Path)new Path(opts.dir + "/files"));
        ContinuousInputFormat.configure(job.getConfiguration(), ingestInstanceId, opts);
        String tableName = clientOpts.getTableName();
        String splitsFile = opts.dir + "/splits.txt";
        try (PrintStream out = new PrintStream(new BufferedOutputStream((OutputStream)fs.create(new Path(splitsFile))));){
            Collection splits = clientOpts.getConnector().tableOperations().listSplits(tableName, opts.reducers - 1);
            for (Text split : splits) {
                out.println(Base64.getEncoder().encodeToString(split.copyBytes()));
            }
            job.setNumReduceTasks(splits.size() + 1);
        }
        job.setPartitionerClass(KeyRangePartitioner.class);
        KeyRangePartitioner.setSplitFile((Job)job, (String)(fs.getUri() + splitsFile));
        job.waitForCompletion(true);
        boolean success = job.isSuccessful();
        return success ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new BulkIngest(), (String[])args);
        System.exit(ret);
    }

    static class Opts
    extends ContinuousOpts {
        @Parameter(names={"--dir"}, description="the bulk dir to use", required=true)
        String dir;
        @Parameter(names={"--reducers"}, description="the number of reducers to use", validateWith={PositiveInteger.class})
        int reducers = 10;
        @Parameter(names={"--mapTasks"}, description="the number of map tasks to use", validateWith={PositiveInteger.class})
        int mapTasks = 10;
        @Parameter(names={"--mapNodes"}, description="the number of linked list key value nodes per mapper", validateWith={PositiveInteger.class})
        int mapNodes = 1000;

        Opts() {
        }
    }
}

