/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.server.util.Admin;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.accumulo.test.functional.FunctionalTestUtils;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class VerifySerialRecoveryIT
extends ConfigurableMacBase {
    private static final byte[] HEXCHARS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final Random random = new Random();

    public static byte[] randomHex(int n) {
        byte[] binary = new byte[n];
        byte[] hex = new byte[n * 2];
        random.nextBytes(binary);
        int count = 0;
        for (byte x : binary) {
            hex[count++] = HEXCHARS[x >> 4 & 0xF];
            hex[count++] = HEXCHARS[x & 0xF];
        }
        return hex;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setNumTservers(1);
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.TSERV_ASSIGNMENT_MAXCONCURRENT, "20");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 240;
    }

    @Test
    public void testSerializedRecovery() throws Exception {
        String tableName = this.getUniqueNames(1)[0];
        Connector c = this.getConnector();
        c.tableOperations().create(tableName);
        TreeSet<Text> splits = new TreeSet<Text>();
        for (int i = 0; i < 200; ++i) {
            splits.add(new Text(VerifySerialRecoveryIT.randomHex(8)));
        }
        c.tableOperations().addSplits(tableName, splits);
        BatchWriter bw = c.createBatchWriter(tableName, null);
        for (int i = 0; i < 50000; ++i) {
            Mutation m = new Mutation(VerifySerialRecoveryIT.randomHex(8));
            m.put((CharSequence)"", (CharSequence)"", (CharSequence)"");
            bw.addMutation(m);
        }
        bw.close();
        for (ProcessReference ref : (Collection)this.getCluster().getProcesses().get(ServerType.TABLET_SERVER)) {
            this.getCluster().killProcess(ServerType.TABLET_SERVER, ref);
        }
        Process ts = this.cluster.exec(TabletServer.class, new String[0]);
        Iterators.size((Iterator)c.createScanner(tableName, Authorizations.EMPTY).iterator());
        Assert.assertEquals((long)0L, (long)this.cluster.exec(Admin.class, new String[]{"stopAll"}).waitFor());
        ts.waitFor();
        String result = FunctionalTestUtils.readAll(this.cluster, TabletServer.class, ts);
        for (String line : result.split("\n")) {
            System.out.println(line);
        }
        boolean started = false;
        int recoveries = 0;
        for (String line : result.split("\n")) {
            if (line.contains("!0") || line.contains("+r")) continue;
            if (line.contains("Starting Write-Ahead Log")) {
                Assert.assertFalse((boolean)started);
                started = true;
                ++recoveries;
            }
            if (!line.contains("Write-Ahead Log recovery complete")) continue;
            Assert.assertTrue((boolean)started);
            started = false;
        }
        Assert.assertFalse((boolean)started);
        Assert.assertTrue((recoveries > 0 ? 1 : 0) != 0);
    }
}

